/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.northstar.common.model.core;

import com.alibaba.fastjson.annotation.JSONField;
import java.time.LocalDate;
import java.util.Objects;
import lombok.Generated;
import org.dromara.northstar.common.constant.ChannelType;
import org.dromara.northstar.common.constant.DateTimeConstant;
import org.dromara.northstar.common.model.core.ContractDefinition;
import xyz.redtorch.pb.CoreEnum;
import xyz.redtorch.pb.CoreField;

public record Contract(String gatewayId, String contractId, String name, String fullName, String thirdPartyId, String unifiedSymbol, String symbol, CoreEnum.ExchangeEnum exchange, CoreEnum.ProductClassEnum productClass, CoreEnum.CurrencyEnum currency, double multiplier, double priceTick, double longMarginRatio, double shortMarginRatio, String underlyingSymbol, double strikePrice, CoreEnum.OptionsTypeEnum optionsType, double underlyingMultiplier, LocalDate lastTradeDate, int maxMarketOrderVolume, int minMarketOrderVolume, int maxLimitOrderVolume, int minLimitOrderVolume, CoreEnum.CombinationTypeEnum combinationType, @JSONField(serialize=false) ContractDefinition contractDefinition, int pricePrecision, int quantityPrecision, boolean tradable, ChannelType channelType) {
    public CoreField.ContractField toContractField() {
        CoreField.ContractField.Builder builder = CoreField.ContractField.newBuilder();
        if (this.gatewayId != null) {
            builder.setGatewayId(this.gatewayId);
        }
        if (this.contractId != null) {
            builder.setContractId(this.contractId);
        }
        if (this.name != null) {
            builder.setName(this.name);
        }
        if (this.fullName != null) {
            builder.setFullName(this.fullName);
        }
        if (this.thirdPartyId != null) {
            builder.setThirdPartyId(this.thirdPartyId);
        }
        if (this.unifiedSymbol != null) {
            builder.setUnifiedSymbol(this.unifiedSymbol);
        }
        if (this.symbol != null) {
            builder.setSymbol(this.symbol);
        }
        if (this.exchange != null) {
            builder.setExchange(this.exchange);
        }
        if (this.productClass != null) {
            builder.setProductClass(this.productClass);
        }
        if (this.currency != null) {
            builder.setCurrency(this.currency);
        }
        if (this.underlyingSymbol != null) {
            builder.setUnderlyingSymbol(this.underlyingSymbol);
        }
        builder.setStrikePrice(this.strikePrice);
        if (this.optionsType != null) {
            builder.setOptionsType(this.optionsType);
        }
        if (this.lastTradeDate != null) {
            builder.setLastTradeDateOrContractMonth(this.lastTradeDate.format(DateTimeConstant.D_FORMAT_INT_FORMATTER));
        }
        if (this.combinationType != null) {
            builder.setCombinationType(this.combinationType);
        }
        if (this.channelType != null) {
            builder.setChannelType(this.channelType.toString());
        }
        builder.setUnderlyingMultiplier(this.underlyingMultiplier);
        builder.setMaxMarketOrderVolume(this.maxMarketOrderVolume);
        builder.setMinMarketOrderVolume(this.minMarketOrderVolume);
        builder.setMaxLimitOrderVolume(this.maxLimitOrderVolume);
        builder.setMinLimitOrderVolume(this.minLimitOrderVolume);
        builder.setMultiplier(this.multiplier);
        builder.setPriceTick(this.priceTick);
        builder.setLongMarginRatio(this.longMarginRatio);
        builder.setShortMarginRatio(this.shortMarginRatio);
        builder.setPricePrecision(this.pricePrecision);
        builder.setQuantityPrecision(this.quantityPrecision);
        return builder.build();
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.channelType, this.contractId, this.gatewayId, this.unifiedSymbol});
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Contract other = (Contract)obj;
        return this.channelType == other.channelType && Objects.equals(this.contractId, other.contractId) && Objects.equals(this.gatewayId, other.gatewayId) && Objects.equals(this.unifiedSymbol, other.unifiedSymbol);
    }

    @Generated
    public static ContractBuilder builder() {
        return new ContractBuilder();
    }

    @Generated
    public ContractBuilder toBuilder() {
        return new ContractBuilder().gatewayId(this.gatewayId).contractId(this.contractId).name(this.name).fullName(this.fullName).thirdPartyId(this.thirdPartyId).unifiedSymbol(this.unifiedSymbol).symbol(this.symbol).exchange(this.exchange).productClass(this.productClass).currency(this.currency).multiplier(this.multiplier).priceTick(this.priceTick).longMarginRatio(this.longMarginRatio).shortMarginRatio(this.shortMarginRatio).underlyingSymbol(this.underlyingSymbol).strikePrice(this.strikePrice).optionsType(this.optionsType).underlyingMultiplier(this.underlyingMultiplier).lastTradeDate(this.lastTradeDate).maxMarketOrderVolume(this.maxMarketOrderVolume).minMarketOrderVolume(this.minMarketOrderVolume).maxLimitOrderVolume(this.maxLimitOrderVolume).minLimitOrderVolume(this.minLimitOrderVolume).combinationType(this.combinationType).contractDefinition(this.contractDefinition).pricePrecision(this.pricePrecision).quantityPrecision(this.quantityPrecision).tradable(this.tradable).channelType(this.channelType);
    }

    @Generated
    public static class ContractBuilder {
        @Generated
        private String gatewayId;
        @Generated
        private String contractId;
        @Generated
        private String name;
        @Generated
        private String fullName;
        @Generated
        private String thirdPartyId;
        @Generated
        private String unifiedSymbol;
        @Generated
        private String symbol;
        @Generated
        private CoreEnum.ExchangeEnum exchange;
        @Generated
        private CoreEnum.ProductClassEnum productClass;
        @Generated
        private CoreEnum.CurrencyEnum currency;
        @Generated
        private double multiplier;
        @Generated
        private double priceTick;
        @Generated
        private double longMarginRatio;
        @Generated
        private double shortMarginRatio;
        @Generated
        private String underlyingSymbol;
        @Generated
        private double strikePrice;
        @Generated
        private CoreEnum.OptionsTypeEnum optionsType;
        @Generated
        private double underlyingMultiplier;
        @Generated
        private LocalDate lastTradeDate;
        @Generated
        private int maxMarketOrderVolume;
        @Generated
        private int minMarketOrderVolume;
        @Generated
        private int maxLimitOrderVolume;
        @Generated
        private int minLimitOrderVolume;
        @Generated
        private CoreEnum.CombinationTypeEnum combinationType;
        @Generated
        private ContractDefinition contractDefinition;
        @Generated
        private int pricePrecision;
        @Generated
        private int quantityPrecision;
        @Generated
        private boolean tradable;
        @Generated
        private ChannelType channelType;

        @Generated
        ContractBuilder() {
        }

        @Generated
        public ContractBuilder gatewayId(String gatewayId) {
            this.gatewayId = gatewayId;
            return this;
        }

        @Generated
        public ContractBuilder contractId(String contractId) {
            this.contractId = contractId;
            return this;
        }

        @Generated
        public ContractBuilder name(String name) {
            this.name = name;
            return this;
        }

        @Generated
        public ContractBuilder fullName(String fullName) {
            this.fullName = fullName;
            return this;
        }

        @Generated
        public ContractBuilder thirdPartyId(String thirdPartyId) {
            this.thirdPartyId = thirdPartyId;
            return this;
        }

        @Generated
        public ContractBuilder unifiedSymbol(String unifiedSymbol) {
            this.unifiedSymbol = unifiedSymbol;
            return this;
        }

        @Generated
        public ContractBuilder symbol(String symbol) {
            this.symbol = symbol;
            return this;
        }

        @Generated
        public ContractBuilder exchange(CoreEnum.ExchangeEnum exchange) {
            this.exchange = exchange;
            return this;
        }

        @Generated
        public ContractBuilder productClass(CoreEnum.ProductClassEnum productClass) {
            this.productClass = productClass;
            return this;
        }

        @Generated
        public ContractBuilder currency(CoreEnum.CurrencyEnum currency) {
            this.currency = currency;
            return this;
        }

        @Generated
        public ContractBuilder multiplier(double multiplier) {
            this.multiplier = multiplier;
            return this;
        }

        @Generated
        public ContractBuilder priceTick(double priceTick) {
            this.priceTick = priceTick;
            return this;
        }

        @Generated
        public ContractBuilder longMarginRatio(double longMarginRatio) {
            this.longMarginRatio = longMarginRatio;
            return this;
        }

        @Generated
        public ContractBuilder shortMarginRatio(double shortMarginRatio) {
            this.shortMarginRatio = shortMarginRatio;
            return this;
        }

        @Generated
        public ContractBuilder underlyingSymbol(String underlyingSymbol) {
            this.underlyingSymbol = underlyingSymbol;
            return this;
        }

        @Generated
        public ContractBuilder strikePrice(double strikePrice) {
            this.strikePrice = strikePrice;
            return this;
        }

        @Generated
        public ContractBuilder optionsType(CoreEnum.OptionsTypeEnum optionsType) {
            this.optionsType = optionsType;
            return this;
        }

        @Generated
        public ContractBuilder underlyingMultiplier(double underlyingMultiplier) {
            this.underlyingMultiplier = underlyingMultiplier;
            return this;
        }

        @Generated
        public ContractBuilder lastTradeDate(LocalDate lastTradeDate) {
            this.lastTradeDate = lastTradeDate;
            return this;
        }

        @Generated
        public ContractBuilder maxMarketOrderVolume(int maxMarketOrderVolume) {
            this.maxMarketOrderVolume = maxMarketOrderVolume;
            return this;
        }

        @Generated
        public ContractBuilder minMarketOrderVolume(int minMarketOrderVolume) {
            this.minMarketOrderVolume = minMarketOrderVolume;
            return this;
        }

        @Generated
        public ContractBuilder maxLimitOrderVolume(int maxLimitOrderVolume) {
            this.maxLimitOrderVolume = maxLimitOrderVolume;
            return this;
        }

        @Generated
        public ContractBuilder minLimitOrderVolume(int minLimitOrderVolume) {
            this.minLimitOrderVolume = minLimitOrderVolume;
            return this;
        }

        @Generated
        public ContractBuilder combinationType(CoreEnum.CombinationTypeEnum combinationType) {
            this.combinationType = combinationType;
            return this;
        }

        @Generated
        public ContractBuilder contractDefinition(ContractDefinition contractDefinition) {
            this.contractDefinition = contractDefinition;
            return this;
        }

        @Generated
        public ContractBuilder pricePrecision(int pricePrecision) {
            this.pricePrecision = pricePrecision;
            return this;
        }

        @Generated
        public ContractBuilder quantityPrecision(int quantityPrecision) {
            this.quantityPrecision = quantityPrecision;
            return this;
        }

        @Generated
        public ContractBuilder tradable(boolean tradable) {
            this.tradable = tradable;
            return this;
        }

        @Generated
        public ContractBuilder channelType(ChannelType channelType) {
            this.channelType = channelType;
            return this;
        }

        @Generated
        public Contract build() {
            return new Contract(this.gatewayId, this.contractId, this.name, this.fullName, this.thirdPartyId, this.unifiedSymbol, this.symbol, this.exchange, this.productClass, this.currency, this.multiplier, this.priceTick, this.longMarginRatio, this.shortMarginRatio, this.underlyingSymbol, this.strikePrice, this.optionsType, this.underlyingMultiplier, this.lastTradeDate, this.maxMarketOrderVolume, this.minMarketOrderVolume, this.maxLimitOrderVolume, this.minLimitOrderVolume, this.combinationType, this.contractDefinition, this.pricePrecision, this.quantityPrecision, this.tradable, this.channelType);
        }

        @Generated
        public String toString() {
            return "Contract.ContractBuilder(gatewayId=" + this.gatewayId + ", contractId=" + this.contractId + ", name=" + this.name + ", fullName=" + this.fullName + ", thirdPartyId=" + this.thirdPartyId + ", unifiedSymbol=" + this.unifiedSymbol + ", symbol=" + this.symbol + ", exchange=" + String.valueOf((Object)this.exchange) + ", productClass=" + String.valueOf((Object)this.productClass) + ", currency=" + String.valueOf((Object)this.currency) + ", multiplier=" + this.multiplier + ", priceTick=" + this.priceTick + ", longMarginRatio=" + this.longMarginRatio + ", shortMarginRatio=" + this.shortMarginRatio + ", underlyingSymbol=" + this.underlyingSymbol + ", strikePrice=" + this.strikePrice + ", optionsType=" + String.valueOf((Object)this.optionsType) + ", underlyingMultiplier=" + this.underlyingMultiplier + ", lastTradeDate=" + String.valueOf(this.lastTradeDate) + ", maxMarketOrderVolume=" + this.maxMarketOrderVolume + ", minMarketOrderVolume=" + this.minMarketOrderVolume + ", maxLimitOrderVolume=" + this.maxLimitOrderVolume + ", minLimitOrderVolume=" + this.minLimitOrderVolume + ", combinationType=" + String.valueOf((Object)this.combinationType) + ", contractDefinition=" + String.valueOf(this.contractDefinition) + ", pricePrecision=" + this.pricePrecision + ", quantityPrecision=" + this.quantityPrecision + ", tradable=" + this.tradable + ", channelType=" + String.valueOf((Object)this.channelType) + ")";
        }
    }
}

