/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.northstar.common.model.core;

import com.alibaba.fastjson.annotation.JSONField;
import java.time.LocalDate;
import java.time.LocalTime;
import lombok.Generated;
import org.dromara.northstar.common.constant.DateTimeConstant;
import org.dromara.northstar.common.model.Identifier;
import org.dromara.northstar.common.model.core.Contract;
import org.dromara.northstar.gateway.IContractManager;
import xyz.redtorch.pb.CoreEnum;
import xyz.redtorch.pb.CoreField;

public record Trade(String gatewayId, String originOrderId, String orderId, CoreEnum.DirectionEnum direction, CoreEnum.OffsetFlagEnum offsetFlag, double price, int volume, CoreEnum.TradeTypeEnum tradeType, CoreEnum.PriceSourceEnum priceSource, LocalDate tradingDay, LocalDate tradeDate, LocalTime tradeTime, long tradeTimestamp, @JSONField(serialize=false) Contract contract) {
    public CoreField.TradeField toTradeField() {
        CoreField.TradeField.Builder builder = CoreField.TradeField.newBuilder();
        if (this.gatewayId != null) {
            builder.setGatewayId(this.gatewayId);
        }
        if (this.originOrderId != null) {
            builder.setOriginOrderId(this.originOrderId);
        }
        if (this.orderId != null) {
            builder.setOrderId(this.orderId);
        }
        if (this.direction != null) {
            builder.setDirection(this.direction);
        }
        if (this.offsetFlag != null) {
            builder.setOffsetFlag(this.offsetFlag);
        }
        if (this.tradeType != null) {
            builder.setTradeType(this.tradeType);
        }
        if (this.priceSource != null) {
            builder.setPriceSource(this.priceSource);
        }
        if (this.tradingDay != null) {
            builder.setTradingDay(this.tradingDay.format(DateTimeConstant.D_FORMAT_INT_FORMATTER));
        }
        if (this.tradeDate != null) {
            builder.setTradeDate(this.tradeDate.format(DateTimeConstant.D_FORMAT_INT_FORMATTER));
        }
        if (this.tradeTime != null) {
            builder.setTradeTime(this.tradeTime.format(DateTimeConstant.T_FORMAT_FORMATTER));
        }
        if (this.contract != null) {
            builder.setContract(this.contract.toContractField());
        }
        return builder.setPrice(this.price).setVolume(this.volume).setTradeTimestamp(this.tradeTimestamp).build();
    }

    public static Trade of(CoreField.TradeField trade, IContractManager contractManager) {
        return Trade.builder().gatewayId(trade.getGatewayId()).originOrderId(trade.getOriginOrderId()).orderId(trade.getOrderId()).direction(trade.getDirection()).offsetFlag(trade.getOffsetFlag()).price(trade.getPrice()).volume(trade.getVolume()).tradeType(trade.getTradeType()).priceSource(trade.getPriceSource()).tradingDay(LocalDate.parse(trade.getTradingDay(), DateTimeConstant.D_FORMAT_INT_FORMATTER)).tradeDate(LocalDate.parse(trade.getTradeDate(), DateTimeConstant.D_FORMAT_INT_FORMATTER)).tradeTime(LocalTime.parse(trade.getTradeTime(), DateTimeConstant.T_FORMAT_FORMATTER)).tradeTimestamp(trade.getTradeTimestamp()).contract(contractManager.getContract(Identifier.of(trade.getContract().getContractId())).contract()).build();
    }

    @Generated
    public static TradeBuilder builder() {
        return new TradeBuilder();
    }

    @Generated
    public TradeBuilder toBuilder() {
        return new TradeBuilder().gatewayId(this.gatewayId).originOrderId(this.originOrderId).orderId(this.orderId).direction(this.direction).offsetFlag(this.offsetFlag).price(this.price).volume(this.volume).tradeType(this.tradeType).priceSource(this.priceSource).tradingDay(this.tradingDay).tradeDate(this.tradeDate).tradeTime(this.tradeTime).tradeTimestamp(this.tradeTimestamp).contract(this.contract);
    }

    @Generated
    public static class TradeBuilder {
        @Generated
        private String gatewayId;
        @Generated
        private String originOrderId;
        @Generated
        private String orderId;
        @Generated
        private CoreEnum.DirectionEnum direction;
        @Generated
        private CoreEnum.OffsetFlagEnum offsetFlag;
        @Generated
        private double price;
        @Generated
        private int volume;
        @Generated
        private CoreEnum.TradeTypeEnum tradeType;
        @Generated
        private CoreEnum.PriceSourceEnum priceSource;
        @Generated
        private LocalDate tradingDay;
        @Generated
        private LocalDate tradeDate;
        @Generated
        private LocalTime tradeTime;
        @Generated
        private long tradeTimestamp;
        @Generated
        private Contract contract;

        @Generated
        TradeBuilder() {
        }

        @Generated
        public TradeBuilder gatewayId(String gatewayId) {
            this.gatewayId = gatewayId;
            return this;
        }

        @Generated
        public TradeBuilder originOrderId(String originOrderId) {
            this.originOrderId = originOrderId;
            return this;
        }

        @Generated
        public TradeBuilder orderId(String orderId) {
            this.orderId = orderId;
            return this;
        }

        @Generated
        public TradeBuilder direction(CoreEnum.DirectionEnum direction) {
            this.direction = direction;
            return this;
        }

        @Generated
        public TradeBuilder offsetFlag(CoreEnum.OffsetFlagEnum offsetFlag) {
            this.offsetFlag = offsetFlag;
            return this;
        }

        @Generated
        public TradeBuilder price(double price) {
            this.price = price;
            return this;
        }

        @Generated
        public TradeBuilder volume(int volume) {
            this.volume = volume;
            return this;
        }

        @Generated
        public TradeBuilder tradeType(CoreEnum.TradeTypeEnum tradeType) {
            this.tradeType = tradeType;
            return this;
        }

        @Generated
        public TradeBuilder priceSource(CoreEnum.PriceSourceEnum priceSource) {
            this.priceSource = priceSource;
            return this;
        }

        @Generated
        public TradeBuilder tradingDay(LocalDate tradingDay) {
            this.tradingDay = tradingDay;
            return this;
        }

        @Generated
        public TradeBuilder tradeDate(LocalDate tradeDate) {
            this.tradeDate = tradeDate;
            return this;
        }

        @Generated
        public TradeBuilder tradeTime(LocalTime tradeTime) {
            this.tradeTime = tradeTime;
            return this;
        }

        @Generated
        public TradeBuilder tradeTimestamp(long tradeTimestamp) {
            this.tradeTimestamp = tradeTimestamp;
            return this;
        }

        @Generated
        public TradeBuilder contract(Contract contract) {
            this.contract = contract;
            return this;
        }

        @Generated
        public Trade build() {
            return new Trade(this.gatewayId, this.originOrderId, this.orderId, this.direction, this.offsetFlag, this.price, this.volume, this.tradeType, this.priceSource, this.tradingDay, this.tradeDate, this.tradeTime, this.tradeTimestamp, this.contract);
        }

        @Generated
        public String toString() {
            return "Trade.TradeBuilder(gatewayId=" + this.gatewayId + ", originOrderId=" + this.originOrderId + ", orderId=" + this.orderId + ", direction=" + String.valueOf((Object)this.direction) + ", offsetFlag=" + String.valueOf((Object)this.offsetFlag) + ", price=" + this.price + ", volume=" + this.volume + ", tradeType=" + String.valueOf((Object)this.tradeType) + ", priceSource=" + String.valueOf((Object)this.priceSource) + ", tradingDay=" + String.valueOf(this.tradingDay) + ", tradeDate=" + String.valueOf(this.tradeDate) + ", tradeTime=" + String.valueOf(this.tradeTime) + ", tradeTimestamp=" + this.tradeTimestamp + ", contract=" + String.valueOf(this.contract) + ")";
        }
    }
}

