/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.northstar.common.utils;

import java.time.LocalDate;
import java.time.LocalTime;
import java.util.HashMap;
import java.util.Map;
import org.springframework.util.Assert;

public class DateTimeUtils {
    private static final Map<LocalTime, LocalTime> cacheTimeMap = new HashMap<LocalTime, LocalTime>();
    private static final LocalTime DAILY_CUTOFF = DateTimeUtils.fromCacheTime(19, 0);

    public LocalDate convertTradingDayForCNMarket(LocalDate actionDay, LocalTime actionTime) {
        if (actionTime.isBefore(DAILY_CUTOFF) && actionDay.getDayOfWeek().getValue() < 6) {
            return actionDay;
        }
        if (actionTime.isAfter(DAILY_CUTOFF) && actionDay.getDayOfWeek().getValue() < 5) {
            return actionDay.plusDays(1L);
        }
        return actionDay.plusDays(8 - actionDay.getDayOfWeek().getValue());
    }

    public static LocalTime fromCacheTime(LocalTime time) {
        Assert.isTrue((time.getSecond() == 0 && time.getNano() == 0 ? 1 : 0) != 0, (String)"\u53ea\u80fd\u7f13\u5b58\u6574\u5206\u949f");
        cacheTimeMap.putIfAbsent(time, time);
        return cacheTimeMap.get(time);
    }

    public static LocalTime fromCacheTime(int hour, int min) {
        return DateTimeUtils.fromCacheTime(LocalTime.of(hour, min));
    }
}

