/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.northstar.common.utils;

import java.lang.reflect.Field;

public class ReflectionUtil {
    private ReflectionUtil() {
    }

    public static void setFieldValue(Object obj, String fieldName, Object value) throws NoSuchFieldException, IllegalAccessException {
        Field field = obj.getClass().getDeclaredField(fieldName);
        field.setAccessible(true);
        Object convertedValue = ReflectionUtil.convertValueToFieldType(value, field.getType());
        field.set(obj, convertedValue);
    }

    public static Object getFieldValue(Object obj, String fieldName) throws NoSuchFieldException, IllegalAccessException {
        Field field = obj.getClass().getDeclaredField(fieldName);
        field.setAccessible(true);
        return field.get(obj);
    }

    private static Object convertValueToFieldType(Object value, Class<?> fieldType) {
        if (value == null) {
            return null;
        }
        if (fieldType.isAssignableFrom(value.getClass())) {
            return value;
        }
        if (fieldType == Integer.TYPE || fieldType == Integer.class) {
            return Integer.parseInt(value.toString());
        }
        if (fieldType == Long.TYPE || fieldType == Long.class) {
            return Long.parseLong(value.toString());
        }
        if (fieldType == Double.TYPE || fieldType == Double.class) {
            return Double.parseDouble(value.toString());
        }
        if (fieldType == Float.TYPE || fieldType == Float.class) {
            return Float.valueOf(Float.parseFloat(value.toString()));
        }
        if (fieldType == Boolean.TYPE || fieldType == Boolean.class) {
            return Boolean.parseBoolean(value.toString());
        }
        if (fieldType == Byte.TYPE || fieldType == Byte.class) {
            return Byte.parseByte(value.toString());
        }
        if (fieldType == Short.TYPE || fieldType == Short.class) {
            return Short.parseShort(value.toString());
        }
        if (fieldType == Character.TYPE || fieldType == Character.class) {
            return Character.valueOf(value.toString().charAt(0));
        }
        throw new IllegalArgumentException("No conversion rule for " + String.valueOf(fieldType));
    }
}

