/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.northstar.gateway.contract;

import java.util.Objects;
import lombok.Generated;
import org.dromara.northstar.common.IDataSource;
import org.dromara.northstar.common.TickDataAware;
import org.dromara.northstar.common.constant.ChannelType;
import org.dromara.northstar.common.event.FastEventEngine;
import org.dromara.northstar.common.event.NorthstarEventType;
import org.dromara.northstar.common.model.Identifier;
import org.dromara.northstar.common.model.core.Contract;
import org.dromara.northstar.common.model.core.Tick;
import org.dromara.northstar.gateway.IContract;
import org.dromara.northstar.gateway.IMarketCenter;
import org.dromara.northstar.gateway.Instrument;
import org.dromara.northstar.gateway.mktdata.MinuteBarGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.redtorch.pb.CoreEnum;

public class GatewayContract
implements IContract,
TickDataAware {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GatewayContract.class);
    private MinuteBarGenerator barGen;
    private Contract contract;
    private Instrument ins;
    private IMarketCenter mktCenter;

    public GatewayContract(IMarketCenter mktCenter, FastEventEngine feEngine, Instrument ins) {
        this.ins = ins;
        this.mktCenter = mktCenter;
        this.contract = ins.contract();
        this.barGen = new MinuteBarGenerator(this.contract, bar -> feEngine.emitEvent(NorthstarEventType.BAR, bar));
    }

    @Override
    public IDataSource dataSource() {
        return this.ins.dataSource();
    }

    @Override
    public boolean subscribe() {
        log.debug("\u8ba2\u9605\uff1a{}", (Object)this.contract.contractId());
        return this.mktCenter.getGateway(this.channelType()).subscribe(this.contract);
    }

    @Override
    public boolean unsubscribe() {
        log.debug("\u9000\u8ba2\uff1a{}", (Object)this.contract.contractId());
        return this.mktCenter.getGateway(this.channelType()).unsubscribe(this.contract);
    }

    @Override
    public void onTick(Tick tick) {
        this.barGen.update(tick);
    }

    @Override
    public Contract contract() {
        return this.contract;
    }

    @Override
    public String name() {
        return this.ins.name();
    }

    @Override
    public Identifier identifier() {
        return this.ins.identifier();
    }

    @Override
    public CoreEnum.ProductClassEnum productClass() {
        return this.ins.productClass();
    }

    @Override
    public CoreEnum.ExchangeEnum exchange() {
        return this.ins.exchange();
    }

    @Override
    public String gatewayId() {
        return this.contract.gatewayId();
    }

    @Override
    public ChannelType channelType() {
        return this.ins.channelType();
    }

    public int hashCode() {
        return Objects.hash(this.contract.contractId());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GatewayContract other = (GatewayContract)obj;
        return Objects.equals(this.contract.contractId(), other.contract.contractId());
    }
}

