/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.northstar.gateway.contract;

import java.time.LocalDate;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.dromara.northstar.common.IDataSource;
import org.dromara.northstar.common.TickDataAware;
import org.dromara.northstar.common.constant.ChannelType;
import org.dromara.northstar.common.event.FastEventEngine;
import org.dromara.northstar.common.event.NorthstarEventType;
import org.dromara.northstar.common.model.Identifier;
import org.dromara.northstar.common.model.core.Contract;
import org.dromara.northstar.common.model.core.Tick;
import org.dromara.northstar.gateway.IContract;
import org.dromara.northstar.gateway.mktdata.IndexTicker;
import org.dromara.northstar.gateway.mktdata.MinuteBarGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.redtorch.pb.CoreEnum;

public class IndexContract
implements IContract,
TickDataAware {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IndexContract.class);
    private final List<IContract> monthContracts;
    private final MinuteBarGenerator barGen;
    private final IndexTicker ticker;
    private final Contract contract;
    private final Identifier identifier;
    private final IDataSource dataSrc;

    public IndexContract(FastEventEngine feEngine, List<IContract> monthContracts) {
        this.monthContracts = monthContracts;
        this.contract = this.makeIndexContractField(monthContracts.get(0).contract());
        this.dataSrc = monthContracts.get(0).dataSource();
        this.identifier = Identifier.of(this.contract.contractId());
        this.barGen = new MinuteBarGenerator(this.contract, bar -> feEngine.emitEvent(NorthstarEventType.BAR, bar));
        this.ticker = new IndexTicker(this, t -> {
            log.debug("\u5408\u6210\u6307\u6570TICK\uff1a{} {} {} {} {}", new Object[]{t.contract().unifiedSymbol(), t.actionDay(), t.actionTime(), t.actionTimestamp(), t.tradingDay()});
            feEngine.emitEvent(NorthstarEventType.TICK, t);
            this.barGen.update((Tick)t);
        });
    }

    private Contract makeIndexContractField(Contract proto) {
        String name = proto.name().replaceAll("\\d+$", "\u6307\u6570");
        String fullName = proto.fullName().replaceAll("\\d+$", "\u6307\u6570");
        String originSymbol = proto.symbol();
        String symbol = originSymbol.replaceAll("\\d+$", "0000");
        String contractId = proto.contractId().replace(originSymbol, symbol);
        String thirdPartyId = proto.thirdPartyId().replace(originSymbol, symbol);
        String unifiedSymbol = proto.unifiedSymbol().replace(originSymbol, symbol);
        return proto.toBuilder().symbol(symbol).thirdPartyId(thirdPartyId).contractId(contractId).lastTradeDate(LocalDate.MAX).unifiedSymbol(unifiedSymbol).name(name).fullName(fullName).longMarginRatio(proto.longMarginRatio()).shortMarginRatio(proto.shortMarginRatio()).tradable(false).build();
    }

    @Override
    public IDataSource dataSource() {
        return this.dataSrc;
    }

    @Override
    public boolean subscribe() {
        log.debug("\u8ba2\u9605\uff1a{}", (Object)this.identifier.value());
        for (IContract c : this.monthContracts) {
            if (c.subscribe()) continue;
            log.warn("[{}] \u5408\u7ea6\u8ba2\u9605\u5931\u8d25", (Object)c.contract().unifiedSymbol());
        }
        return true;
    }

    @Override
    public boolean unsubscribe() {
        log.debug("\u9000\u8ba2\uff1a{}", (Object)this.identifier.value());
        for (IContract c : this.monthContracts) {
            if (c.unsubscribe()) continue;
            log.warn("[{}] \u5408\u7ea6\u53d6\u6d88\u8ba2\u9605\u5931\u8d25", (Object)c.contract().unifiedSymbol());
        }
        return true;
    }

    @Override
    public void onTick(Tick tick) {
        log.trace("{} \u5408\u7ea6\u6536\u5230\u6708\u4efd\u5408\u7ea6\u6570\u636e\uff1a{}", (Object)this.contract.unifiedSymbol(), (Object)tick.contract().unifiedSymbol());
        this.ticker.update(tick);
    }

    @Override
    public List<IContract> memberContracts() {
        return this.monthContracts;
    }

    @Override
    public Contract contract() {
        return this.contract;
    }

    @Override
    public String name() {
        return this.contract.name();
    }

    @Override
    public Identifier identifier() {
        return this.identifier;
    }

    @Override
    public CoreEnum.ProductClassEnum productClass() {
        return this.contract.productClass();
    }

    @Override
    public CoreEnum.ExchangeEnum exchange() {
        return this.contract.exchange();
    }

    @Override
    public String gatewayId() {
        return this.contract.gatewayId();
    }

    @Override
    public ChannelType channelType() {
        return this.monthContracts.get(0).channelType();
    }

    public int hashCode() {
        return Objects.hash(this.contract.contractId());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IndexContract other = (IndexContract)obj;
        return StringUtils.equals((CharSequence)this.contract.contractId(), (CharSequence)other.contract.contractId());
    }
}

