/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.northstar.gateway.mktdata;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.dromara.northstar.common.TickDataAware;
import org.dromara.northstar.common.constant.ChannelType;
import org.dromara.northstar.common.event.FastEventEngine;
import org.dromara.northstar.common.exception.NoSuchElementException;
import org.dromara.northstar.common.model.Identifier;
import org.dromara.northstar.common.model.core.Contract;
import org.dromara.northstar.common.model.core.ContractDefinition;
import org.dromara.northstar.common.model.core.Tick;
import org.dromara.northstar.gateway.IContract;
import org.dromara.northstar.gateway.IMarketCenter;
import org.dromara.northstar.gateway.Instrument;
import org.dromara.northstar.gateway.MarketGateway;
import org.dromara.northstar.gateway.contract.GatewayContract;
import org.dromara.northstar.gateway.contract.IndexContract;
import org.dromara.northstar.gateway.contract.OptionChainContract;
import org.dromara.northstar.gateway.contract.PrimaryContract;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.redtorch.pb.CoreEnum;

public class MarketCenter
implements IMarketCenter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MarketCenter.class);
    private static final int INIT_SIZE = 16384;
    private final ConcurrentMap<Identifier, IContract> contractMap = new ConcurrentHashMap<Identifier, IContract>(16384);
    private final ConcurrentMap<IContract, IndexContract> idxContractMap = new ConcurrentHashMap<IContract, IndexContract>(16384);
    private final Table<ChannelType, String, IContract> channelSymbolContractTbl = HashBasedTable.create();
    private final Table<CoreEnum.ExchangeEnum, CoreEnum.ProductClassEnum, List<ContractDefinition>> contractDefTbl = HashBasedTable.create();
    private final Table<ChannelType, ContractDefinition, List<IContract>> channelDefContractGroups = HashBasedTable.create();
    private final Map<ChannelType, MarketGateway> gatewayMap = new EnumMap<ChannelType, MarketGateway>(ChannelType.class);
    private final ConcurrentMap<Contract, Tick> tickMap = new ConcurrentHashMap<Contract, Tick>();
    private final FastEventEngine feEngine;
    private Set<ChannelType> loadedGroupOfChannel = new HashSet<ChannelType>();

    public MarketCenter(FastEventEngine feEngine) {
        this.feEngine = feEngine;
    }

    @Override
    public void addDefinitions(List<ContractDefinition> contractDefs) {
        for (ContractDefinition def : contractDefs) {
            if (!this.contractDefTbl.contains((Object)def.exchange(), (Object)def.productClass())) {
                this.contractDefTbl.put((Object)def.exchange(), (Object)def.productClass(), new ArrayList(512));
            }
            ((List)this.contractDefTbl.get((Object)def.exchange(), (Object)def.productClass())).add(def);
        }
    }

    @Override
    public synchronized void addInstrument(Instrument ins) {
        if (this.contractMap.containsKey(ins.identifier())) {
            log.debug("[{}] \u5408\u7ea6\u5df2\u6ce8\u518c\uff0c\u4e0d\u9700\u8981\u91cd\u590d\u6ce8\u518c", (Object)ins.identifier().value());
            return;
        }
        this.getDefinition(ins.exchange(), ins.productClass(), ins.identifier().value()).ifPresent(def -> {
            log.debug("[{}] \u5339\u914d\u5408\u7ea6\u5b9a\u4e49 [{} {} {}]", new Object[]{ins.identifier().value(), def.exchange(), def.productClass(), def.symbolPattern().pattern()});
            ins.setContractDefinition((ContractDefinition)def);
            GatewayContract contract = new GatewayContract(this, this.feEngine, ins);
            this.contractMap.put(ins.identifier(), contract);
            if (!this.channelDefContractGroups.contains((Object)ins.channelType(), def)) {
                this.channelDefContractGroups.put((Object)ins.channelType(), def, new ArrayList());
            }
            ((List)this.channelDefContractGroups.get((Object)ins.channelType(), def)).add(contract);
            this.channelSymbolContractTbl.put((Object)contract.channelType(), (Object)contract.contract().symbol(), (Object)contract);
            this.channelSymbolContractTbl.put((Object)contract.channelType(), (Object)contract.contract().unifiedSymbol(), (Object)contract);
            if (log.isTraceEnabled()) {
                log.trace("\u5408\u7ea6\u767b\u8bb0\u6210\u529f\uff1a{}", (Object)contract.contract());
            }
        });
        if (!this.contractMap.containsKey(ins.identifier())) {
            log.debug("\u672a\u627e\u5230 [{}] \u7684\u5408\u7ea6\u5b9a\u4e49\uff0c\u5ffd\u7565\u8be5\u5408\u7ea6\u7684\u6ce8\u518c", (Object)ins.identifier().value());
        }
    }

    @Override
    public Optional<ContractDefinition> getDefinition(CoreEnum.ExchangeEnum exchange, CoreEnum.ProductClassEnum productClass, String identifier) {
        List defList = (List)this.contractDefTbl.get((Object)exchange, (Object)productClass);
        if (Objects.isNull(defList)) {
            return Optional.empty();
        }
        for (ContractDefinition def : defList) {
            if (!def.symbolPattern().matcher(identifier).matches()) continue;
            return Optional.of(def);
        }
        return Optional.empty();
    }

    @Override
    public synchronized void loadContractGroup(ChannelType channelType) {
        List<IContract> gatewayContracts = this.getContracts(channelType);
        HashMap<String, IContract> symbolContractMap = new HashMap<String, IContract>();
        for (IContract c2 : gatewayContracts) {
            symbolContractMap.put(c2.contract().symbol(), c2);
        }
        try {
            this.aggregateOptionContracts(gatewayContracts.stream().filter(c -> c.productClass() == CoreEnum.ProductClassEnum.OPTION).toList(), symbolContractMap);
        }
        catch (Exception e) {
            log.error("\u805a\u5408\u671f\u6743\u94fe\u5408\u7ea6\u65f6\u51fa\u9519", (Throwable)e);
        }
        try {
            this.aggregateFutureIndexContracts(this.channelDefContractGroups.row((Object)channelType));
        }
        catch (Exception e) {
            log.error("\u805a\u5408\u671f\u8d27\u6307\u6570\u5408\u7ea6\u65f6\u51fa\u9519", (Throwable)e);
        }
        this.loadedGroupOfChannel.add(channelType);
    }

    private void aggregateOptionContracts(List<IContract> optContracts, Map<String, IContract> symbolContractMap) {
        HashMap<String, List> symbolOptionsMap = new HashMap<String, List>();
        for (IContract iContract : optContracts) {
            if (iContract instanceof OptionChainContract) continue;
            String underlyingSymbol = iContract.contract().underlyingSymbol();
            symbolOptionsMap.computeIfAbsent(underlyingSymbol, key -> new ArrayList());
            ((List)symbolOptionsMap.get(underlyingSymbol)).add(iContract);
        }
        for (Map.Entry entry : symbolOptionsMap.entrySet()) {
            if (!symbolContractMap.containsKey(entry.getKey())) {
                log.warn("\u627e\u4e0d\u5230{}\u5bf9\u5e94\u7684\u5408\u7ea6\u4fe1\u606f", entry.getKey());
                continue;
            }
            OptionChainContract c = new OptionChainContract(symbolContractMap.get(entry.getKey()), (List)entry.getValue());
            Contract cc = c.contract();
            this.contractMap.put(c.identifier(), c);
            this.channelSymbolContractTbl.put((Object)c.channelType(), (Object)cc.symbol(), (Object)c);
            this.channelSymbolContractTbl.put((Object)c.channelType(), (Object)cc.unifiedSymbol(), (Object)c);
        }
    }

    private void aggregateFutureIndexContracts(Map<ContractDefinition, List<IContract>> contractDefMap) {
        for (Map.Entry<ContractDefinition, List<IContract>> e : contractDefMap.entrySet()) {
            if (e.getKey().productClass() != CoreEnum.ProductClassEnum.FUTURES) continue;
            IndexContract c = new IndexContract(this.feEngine, e.getValue());
            this.contractMap.put(c.identifier(), c);
            for (IContract memberContract : c.memberContracts()) {
                this.idxContractMap.put(memberContract, c);
            }
            this.channelSymbolContractTbl.put((Object)c.channelType(), (Object)c.contract().symbol(), (Object)c);
            this.channelSymbolContractTbl.put((Object)c.channelType(), (Object)c.contract().unifiedSymbol(), (Object)c);
            if (c.channelType() != ChannelType.PLAYBACK) continue;
            PrimaryContract pc = new PrimaryContract(c);
            this.contractMap.put(pc.identifier(), pc);
            this.channelSymbolContractTbl.put((Object)pc.channelType(), (Object)pc.contract().symbol(), (Object)pc);
            this.channelSymbolContractTbl.put((Object)pc.channelType(), (Object)pc.contract().unifiedSymbol(), (Object)pc);
        }
    }

    @Override
    public IContract getContract(Identifier identifier) {
        if (!this.contractMap.containsKey(identifier)) {
            throw new NoSuchElementException(String.format("\u627e\u4e0d\u5230\u5408\u7ea6\uff1a%s", identifier.value()));
        }
        return (IContract)this.contractMap.get(identifier);
    }

    @Override
    public IContract getContract(ChannelType channelType, String code) {
        if (!this.channelSymbolContractTbl.contains((Object)channelType, (Object)code)) {
            throw new NoSuchElementException(String.format("\u627e\u4e0d\u5230\u5408\u7ea6\uff1a%s -> %s", new Object[]{channelType, code}));
        }
        return (IContract)this.channelSymbolContractTbl.get((Object)channelType, (Object)code);
    }

    @Override
    public List<IContract> getContracts(String gatewayId) {
        if (StringUtils.isBlank((CharSequence)gatewayId)) {
            return this.contractMap.values().stream().toList();
        }
        return this.contractMap.values().stream().filter(c -> StringUtils.equals((CharSequence)gatewayId, (CharSequence)c.gatewayId())).toList();
    }

    @Override
    public List<IContract> getContracts(ChannelType channelType) {
        return this.contractMap.values().stream().filter(c -> c.channelType() == channelType).toList();
    }

    @Override
    public void onTick(Tick tick) {
        IndexContract idxContract;
        if (this.tickMap.containsKey(tick.contract()) && this.tickMap.get(tick.contract()) == tick) {
            return;
        }
        this.tickMap.put(tick.contract(), tick);
        if (tick.contract().unifiedSymbol().contains("0000")) {
            return;
        }
        IContract contract = this.getContract(tick.channelType(), tick.contract().unifiedSymbol());
        if (contract instanceof TickDataAware) {
            TickDataAware tdAware = (TickDataAware)((Object)contract);
            tdAware.onTick(tick);
        }
        if (Objects.nonNull(idxContract = (IndexContract)this.idxContractMap.get(contract))) {
            idxContract.onTick(tick);
        } else if (contract.productClass() == CoreEnum.ProductClassEnum.FUTURES && this.loadedGroupOfChannel.contains((Object)tick.channelType())) {
            log.trace("\u6ca1\u6709\u627e\u5230 [{}] \u5bf9\u5e94\u7684\u6307\u6570\u5408\u7ea6", (Object)contract.identifier());
        }
    }

    @Override
    public void addGateway(MarketGateway gateway) {
        log.info("\u6ce8\u518c\u7f51\u5173\uff1a{}", (Object)gateway.gatewayId());
        this.gatewayMap.put(gateway.channelType(), gateway);
    }

    @Override
    public MarketGateway getGateway(ChannelType channelType) {
        return this.gatewayMap.get((Object)channelType);
    }

    @Override
    public Optional<Tick> lastTick(Contract contract) {
        return Optional.ofNullable((Tick)this.tickMap.get(contract));
    }
}

