/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.northstar.gateway.mktdata;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.List;
import org.dromara.northstar.common.IDataSource;
import org.dromara.northstar.common.constant.ChannelType;
import org.dromara.northstar.common.constant.DateTimeConstant;
import org.dromara.northstar.common.model.ResultSet;
import org.dromara.northstar.common.model.core.Bar;
import org.dromara.northstar.common.model.core.Contract;
import org.dromara.northstar.common.utils.CommonUtils;
import org.dromara.northstar.gateway.mktdata.QuantitDataServiceManager;
import org.springframework.util.Assert;
import xyz.redtorch.pb.CoreEnum;

public class NorthstarDataSource
implements IDataSource {
    private QuantitDataServiceManager dataService;

    public NorthstarDataSource(QuantitDataServiceManager dataService) {
        this.dataService = dataService;
    }

    @Override
    public List<Bar> getMinutelyData(Contract contract, LocalDate startDate, LocalDate endDate) {
        return this.convertMinuteData(this.dataService.getMinutelyData(contract.unifiedSymbol(), startDate, endDate), contract);
    }

    @Override
    public List<Bar> getQuarterlyData(Contract contract, LocalDate startDate, LocalDate endDate) {
        return this.convertMinuteData(this.dataService.getQuarterlyData(contract.unifiedSymbol(), startDate, endDate), contract);
    }

    @Override
    public List<Bar> getHourlyData(Contract contract, LocalDate startDate, LocalDate endDate) {
        return this.convertMinuteData(this.dataService.getHourlyData(contract.unifiedSymbol(), startDate, endDate), contract);
    }

    private List<Bar> convertMinuteData(ResultSet rs, Contract contract) {
        return rs.toJSONList().stream().map(json -> Bar.builder().actionDay(LocalDate.parse(json.getString("trade_time").substring(0, 10))).actionTime(LocalTime.parse(json.getString("trade_time").substring(11))).actionTimestamp(CommonUtils.localDateTimeToMills(LocalDateTime.parse(json.getString("trade_time"), DateTimeConstant.DT_FORMAT_FORMATTER))).tradingDay(LocalDate.parse(json.getString("trading_day"))).channelType(contract.channelType()).gatewayId(String.valueOf((Object)contract.channelType())).contract(contract).openPrice(this.indexContractPriceEnhance(contract, json.getDoubleValue("open"))).closePrice(this.indexContractPriceEnhance(contract, json.getDoubleValue("close"))).highPrice(this.indexContractPriceEnhance(contract, json.getDoubleValue("high"))).lowPrice(this.indexContractPriceEnhance(contract, json.getDoubleValue("low"))).openInterest(json.getDoubleValue("oi")).openInterestDelta(json.getDoubleValue("oi_delta")).volume(json.getLongValue("vol")).volumeDelta(json.getLongValue("vol_delta")).turnover(json.getDoubleValue("amount")).turnoverDelta(json.getDoubleValue("amount_delta")).preOpenInterest(json.getDoubleValue("pre_oi")).build()).toList();
    }

    private double indexContractPriceEnhance(Contract contract, double price) {
        if (!contract.symbol().contains("0000")) {
            return price;
        }
        int numOfPriceTickInPrice = (int)(price * 1000.0) / (int)(contract.priceTick() * 1000.0);
        return (double)numOfPriceTickInPrice * contract.priceTick();
    }

    @Override
    public List<Bar> getDailyData(Contract contract, LocalDate startDate, LocalDate endDate) {
        return this.dataService.getDailyData(contract.unifiedSymbol(), startDate, endDate).toJSONList().stream().map(json -> Bar.builder().actionDay(LocalDate.parse(json.getString("trade_date"), DateTimeConstant.D_FORMAT_INT_FORMATTER)).tradingDay(LocalDate.parse(json.getString("trade_date"), DateTimeConstant.D_FORMAT_INT_FORMATTER)).channelType(contract.channelType()).gatewayId(String.valueOf((Object)contract.channelType())).contract(contract).openPrice(this.indexContractPriceEnhance(contract, json.getDoubleValue("open"))).closePrice(this.indexContractPriceEnhance(contract, json.getDoubleValue("close"))).highPrice(this.indexContractPriceEnhance(contract, json.getDoubleValue("high"))).lowPrice(this.indexContractPriceEnhance(contract, json.getDoubleValue("low"))).openInterest(json.getDoubleValue("oi")).openInterestDelta(json.getDoubleValue("oi_chg")).volume(json.getLongValue("vol")).volumeDelta(json.getLongValue("vol")).turnover(json.getDoubleValue("amount")).turnoverDelta(json.getDoubleValue("amount")).preOpenInterest(json.getDoubleValue("pre_oi")).preClosePrice(this.indexContractPriceEnhance(contract, json.getDoubleValue("pre_close"))).preSettlePrice(json.getDoubleValue("pre_settle")).build()).toList();
    }

    @Override
    public List<LocalDate> getHolidays(ChannelType channelType, LocalDate startDate, LocalDate endDate) {
        Assert.isTrue((channelType == ChannelType.CTP ? 1 : 0) != 0, (String)"\u53ea\u80fd\u67e5\u8be2CTP\u7684\u4ea4\u6613\u65e5");
        Assert.isTrue((startDate.getYear() == endDate.getYear() ? 1 : 0) != 0, (String)"\u53ea\u80fd\u67e5\u8be2\u540c\u4e00\u5e74\u7684\u4ea4\u6613\u65e5");
        return this.dataService.getCalendarCN(startDate.getYear()).toJSONList().stream().filter(json -> json.getIntValue("is_open") == 0).map(json -> LocalDate.parse(json.getString("date"), DateTimeConstant.D_FORMAT_INT_FORMATTER)).toList();
    }

    @Override
    public List<Contract> getAllContracts() {
        List<Contract> futures = this.dataService.getAllFutureContracts().toJSONList().stream().map(json -> Contract.builder().unifiedSymbol(json.getString("unifiedSymbol")).symbol(json.getString("symbol")).underlyingSymbol(json.getString("fut_code")).name(json.getString("name")).fullName(json.getString("name")).productClass(CoreEnum.ProductClassEnum.FUTURES).exchange(CoreEnum.ExchangeEnum.valueOf(json.getString("exchange"))).currency(CoreEnum.CurrencyEnum.CNY).multiplier(json.getDoubleValue("multiplier")).priceTick(json.getDoubleValue("price_tick")).lastTradeDate(LocalDate.parse(json.getString("delist_date"), DateTimeConstant.D_FORMAT_INT_FORMATTER)).longMarginRatio(0.1).shortMarginRatio(0.1).build()).toList();
        List<Contract> options = this.dataService.getAllOptionContracts().toJSONList().stream().map(json -> {
            Contract.ContractBuilder contractBuilder = Contract.builder().unifiedSymbol(json.getString("unifiedSymbol")).symbol(json.getString("symbol")).underlyingSymbol(json.getString("fut_code")).name(json.getString("name")).fullName(json.getString("name")).productClass(CoreEnum.ProductClassEnum.OPTION).exchange(CoreEnum.ExchangeEnum.valueOf(json.getString("exchange"))).currency(CoreEnum.CurrencyEnum.CNY).multiplier(json.getDoubleValue("multiplier")).priceTick(json.getDoubleValue("price_tick")).lastTradeDate(LocalDate.parse(json.getString("delist_date"), DateTimeConstant.D_FORMAT_INT_FORMATTER)).strikePrice(json.getDoubleValue("strike_price"));
            return contractBuilder.optionsType(switch (json.getString("call_put")) {
                case "C" -> CoreEnum.OptionsTypeEnum.O_CallOptions;
                case "P" -> CoreEnum.OptionsTypeEnum.O_PutOptions;
                default -> throw new IllegalArgumentException("Unexpected value: " + json.getString("call_put"));
            }).longMarginRatio(1.0).shortMarginRatio(1.0).build();
        }).toList();
        ArrayList<Contract> results = new ArrayList<Contract>(futures.size() + options.size());
        results.addAll(futures);
        results.addAll(options);
        return results;
    }
}

