/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.northstar.gateway.mktdata;

import java.time.LocalDate;
import org.dromara.northstar.common.model.ResultSet;
import org.springframework.web.client.RestTemplate;

public class QuantitDataServiceManager {
    private RestTemplate restTemplate;

    public QuantitDataServiceManager(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }

    public ResultSet getAllFutureContracts() {
        return (ResultSet)this.restTemplate.getForObject("/dataservice/contracts/future", ResultSet.class, new Object[0]);
    }

    public ResultSet getAllOptionContracts() {
        return (ResultSet)this.restTemplate.getForObject("/dataservice/contracts/option", ResultSet.class, new Object[0]);
    }

    public ResultSet getCalendarCN(int year) {
        return (ResultSet)this.restTemplate.getForObject("/dataservice/calendar/cn?year={year}", ResultSet.class, new Object[]{year});
    }

    public ResultSet getMinutelyData(String unifiedSymbol, LocalDate start, LocalDate end) {
        return (ResultSet)this.restTemplate.getForObject("/dataservice/data/min?unifiedSymbol={unifiedSymbol}&startDate={start}&endDate={end}", ResultSet.class, new Object[]{unifiedSymbol, start, end});
    }

    public ResultSet getQuarterlyData(String unifiedSymbol, LocalDate start, LocalDate end) {
        return (ResultSet)this.restTemplate.getForObject("/dataservice/data/quarter?unifiedSymbol={unifiedSymbol}&startDate={start}&endDate={end}", ResultSet.class, new Object[]{unifiedSymbol, start, end});
    }

    public ResultSet getHourlyData(String unifiedSymbol, LocalDate start, LocalDate end) {
        return (ResultSet)this.restTemplate.getForObject("/dataservice/data/hour?unifiedSymbol={unifiedSymbol}&startDate={start}&endDate={end}", ResultSet.class, new Object[]{unifiedSymbol, start, end});
    }

    public ResultSet getDailyData(String unifiedSymbol, LocalDate start, LocalDate end) {
        return (ResultSet)this.restTemplate.getForObject("/dataservice/data/day?unifiedSymbol={unifiedSymbol}&startDate={start}&endDate={end}", ResultSet.class, new Object[]{unifiedSymbol, start, end});
    }
}

