/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.northstar.indicator.momentum;

import java.util.List;
import org.dromara.northstar.indicator.AbstractIndicator;
import org.dromara.northstar.indicator.Indicator;
import org.dromara.northstar.indicator.constant.ValueType;
import org.dromara.northstar.indicator.helper.HHVIndicator;
import org.dromara.northstar.indicator.helper.LLVIndicator;
import org.dromara.northstar.indicator.helper.SimpleValueIndicator;
import org.dromara.northstar.indicator.model.Configuration;
import org.dromara.northstar.indicator.model.Num;
import org.dromara.northstar.indicator.trend.SMAIndicator;

public class KDIndicator
extends AbstractIndicator
implements Indicator {
    private Indicator rsv;
    private Indicator k;
    private Indicator d;

    public KDIndicator(Configuration cfg, int barCount, int m1, int m2) {
        super(cfg.toBuilder().visible(false).build());
        this.rsv = new RSVIndicator(this, cfg.toBuilder().visible(false).build(), barCount);
        this.k = new SMAIndicator(cfg.toBuilder().indicatorName(cfg.indicatorName() + "_k").build(), this.rsv, m1, 1);
        this.d = new SMAIndicator(cfg.toBuilder().indicatorName(cfg.indicatorName() + "_d").build(), this.k, m2, 1);
    }

    @Override
    protected Num evaluate(Num num) {
        return num;
    }

    @Override
    public Num get(int step) {
        return Num.NaN();
    }

    @Override
    public List<Indicator> dependencies() {
        return List.of(this.d);
    }

    public Indicator getK() {
        return this.k;
    }

    public Indicator getD() {
        return this.d;
    }

    public class RSVIndicator
    extends AbstractIndicator
    implements Indicator {
        private Indicator close;
        private Indicator high;
        private Indicator low;
        private Indicator llv;
        private Indicator hhv;

        public RSVIndicator(KDIndicator this$0, Configuration cfg, int barCount) {
            super(cfg);
            this.close = new SimpleValueIndicator(cfg.toBuilder().valueType(ValueType.CLOSE).visible(false).build());
            this.high = new SimpleValueIndicator(cfg.toBuilder().cacheLength(barCount).valueType(ValueType.HIGH).visible(false).build());
            this.low = new SimpleValueIndicator(cfg.toBuilder().cacheLength(barCount).valueType(ValueType.LOW).visible(false).build());
            this.llv = new LLVIndicator(cfg.toBuilder().visible(false).build(), this.low);
            this.hhv = new HHVIndicator(cfg.toBuilder().visible(false).build(), this.high);
        }

        @Override
        public List<Indicator> dependencies() {
            return List.of(this.close, this.llv, this.hhv);
        }

        @Override
        protected Num evaluate(Num num) {
            double val = (this.close.value(0) - this.llv.value(0)) / (this.hhv.value(0) - this.llv.value(0)) * 100.0;
            return Num.of(val, num.timestamp(), num.unstable());
        }
    }
}

