/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.northstar.strategy.constant;

import lombok.Generated;
import org.dromara.northstar.common.constant.SignalOperation;
import org.dromara.northstar.common.model.core.Tick;

public enum PriceType {
    ANY_PRICE("\u5e02\u4ef7"){

        @Override
        public double resolvePrice(Tick tick, SignalOperation operation, double price) {
            return operation.isBuy() ? tick.upperLimit() : tick.lowerLimit();
        }
    }
    ,
    OPP_PRICE("\u5bf9\u624b\u4ef7"){

        @Override
        public double resolvePrice(Tick tick, SignalOperation operation, double price) {
            return operation.isBuy() ? tick.askPrice().get(0) : tick.bidPrice().get(0);
        }
    }
    ,
    LAST_PRICE("\u6700\u65b0\u4ef7"){

        @Override
        public double resolvePrice(Tick tick, SignalOperation operation, double price) {
            return tick.lastPrice();
        }
    }
    ,
    WAITING_PRICE("\u6392\u961f\u4ef7"){

        @Override
        public double resolvePrice(Tick tick, SignalOperation operation, double price) {
            return operation.isBuy() ? tick.bidPrice().get(0) : tick.askPrice().get(0);
        }
    }
    ,
    LIMIT_PRICE("\u9650\u4ef7"){

        @Override
        public double resolvePrice(Tick tick, SignalOperation operation, double price) {
            return price;
        }
    };

    private String name;

    private PriceType(String name) {
        this.name = name;
    }

    public abstract double resolvePrice(Tick var1, SignalOperation var2, double var3);

    @Generated
    public String getName() {
        return this.name;
    }
}

