/*
 *
 * Copyright 2017-2018 549477611@qq.com(xiaoyu)
 *
 * This copyrighted material is made available to anyone wishing to use, modify,
 * copy, or redistribute it subject to the terms and conditions of the GNU
 * Lesser General Public License, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License
 * for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this distribution; if not, see <http://www.gnu.org/licenses/>.
 *
 */

package org.dromara.raincat.common.bean;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.Getter;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * TransactionInvocation.
 * @author xiaoyu
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class TransactionInvocation implements Serializable {

    private static final long serialVersionUID = 7722060715819141844L;

    /**
     * 事务执行器.
     */
    @Getter
    private Class targetClazz;

    /**
     * 方法.
     */
    @Getter
    private String method;

    /**
     * 参数值.
     */
    @Getter
    private Object[] argumentValues;

    /**
     * 参数类型.
     */
    @Getter
    private Class[] argumentTypes;

}
