/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.raincat.common.enums;

import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;

public enum NettyMessageActionEnum {
    CREATE_GROUP(0, "\u521b\u5efa\u4e8b\u52a1\u7ec4"),
    ADD_TRANSACTION(1, "\u6dfb\u52a0\u4e8b\u52a1"),
    UPDATE_TRANSACTION(2, "\u66f4\u65b0\u4e8b\u52a1"),
    PRE_COMMIT(3, "\u9884\u63d0\u4ea4"),
    COMPLETE_COMMIT(4, "\u5b8c\u6210\u63d0\u4ea4"),
    ROLLBACK(5, "\u56de\u6eda"),
    FAILURE(6, "\u5931\u8d25"),
    HEART(7, "\u5fc3\u8df3"),
    SEND(8, "\u53d1\u9001"),
    RECEIVE(9, "\u63a5\u6536"),
    GET_TRANSACTION_GROUP_STATUS(10, "\u83b7\u53d6\u4e8b\u52a1\u7ec4\u72b6\u6001"),
    FIND_TRANSACTION_GROUP_INFO(11, "\u83b7\u53d6\u4e8b\u52a1\u7ec4\u4fe1\u606f");

    private int code;
    private String desc;

    private NettyMessageActionEnum(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static NettyMessageActionEnum acquireByCode(int code) {
        Optional<NettyMessageActionEnum> actionEnum = Arrays.stream(NettyMessageActionEnum.values()).filter(v -> Objects.equals(v.getCode(), code)).findFirst();
        return actionEnum.orElse(HEART);
    }

    public int getCode() {
        return this.code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}

