/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.raincat.common.enums;

import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;

public enum TransactionStatusEnum {
    ROLLBACK(0, "\u56de\u6eda"),
    COMMIT(1, "\u5df2\u7ecf\u63d0\u4ea4"),
    BEGIN(2, "\u5f00\u59cb"),
    RUNNING(3, "\u6267\u884c\u4e2d"),
    FAILURE(4, "\u5931\u8d25"),
    PRE_COMMIT(5, "\u9884\u63d0\u4ea4"),
    LOCK(6, "\u9501\u5b9a");

    private int code;
    private String desc;

    private TransactionStatusEnum(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static TransactionStatusEnum acquireByCode(int code) {
        Optional<TransactionStatusEnum> transactionStatusEnum = Arrays.stream(TransactionStatusEnum.values()).filter(v -> Objects.equals(v.getCode(), code)).findFirst();
        return transactionStatusEnum.orElse(BEGIN);
    }

    public static String acquireDescByCode(int code) {
        return TransactionStatusEnum.acquireByCode(code).getDesc();
    }

    public int getCode() {
        return this.code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}

