/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.raincat.common.jedis;

import java.util.Set;
import org.dromara.raincat.common.jedis.JedisClient;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

public class JedisClientSingle
implements JedisClient {
    private JedisPool jedisPool;

    public JedisClientSingle(JedisPool jedisPool) {
        this.jedisPool = jedisPool;
    }

    @Override
    public String set(String key, String value) {
        try (Jedis jedis = this.jedisPool.getResource();){
            String string = jedis.set(key, value);
            return string;
        }
    }

    @Override
    public String set(String key, byte[] value) {
        try (Jedis jedis = this.jedisPool.getResource();){
            String string = jedis.set(key.getBytes(), value);
            return string;
        }
    }

    @Override
    public Long del(String ... keys) {
        try (Jedis jedis = this.jedisPool.getResource();){
            Long l = jedis.del(keys);
            return l;
        }
    }

    @Override
    public String get(String key) {
        try (Jedis jedis = this.jedisPool.getResource();){
            String string = jedis.get(key);
            return string;
        }
    }

    @Override
    public byte[] get(byte[] key) {
        try (Jedis jedis = this.jedisPool.getResource();){
            byte[] byArray = jedis.get(key);
            return byArray;
        }
    }

    @Override
    public Set<byte[]> keys(byte[] pattern) {
        try (Jedis jedis = this.jedisPool.getResource();){
            Set set = jedis.keys(pattern);
            return set;
        }
    }

    @Override
    public Set<String> keys(String key) {
        try (Jedis jedis = this.jedisPool.getResource();){
            Set set = jedis.keys(key);
            return set;
        }
    }

    @Override
    public Long hset(String key, String item, String value) {
        try (Jedis jedis = this.jedisPool.getResource();){
            Long l = jedis.hset(key, item, value);
            return l;
        }
    }

    @Override
    public String hget(String key, String item) {
        try (Jedis jedis = this.jedisPool.getResource();){
            String string = jedis.hget(key, item);
            return string;
        }
    }

    @Override
    public Long hdel(String key, String item) {
        try (Jedis jedis = this.jedisPool.getResource();){
            Long l = jedis.hdel(key, new String[]{item});
            return l;
        }
    }

    @Override
    public Long incr(String key) {
        try (Jedis jedis = this.jedisPool.getResource();){
            Long l = jedis.incr(key);
            return l;
        }
    }

    @Override
    public Long decr(String key) {
        try (Jedis jedis = this.jedisPool.getResource();){
            Long l = jedis.decr(key);
            return l;
        }
    }

    @Override
    public Long expire(String key, int second) {
        try (Jedis jedis = this.jedisPool.getResource();){
            Long l = jedis.expire(key, second);
            return l;
        }
    }

    @Override
    public Set<String> zrange(String key, long start, long end) {
        try (Jedis jedis = this.jedisPool.getResource();){
            Set set = jedis.zrange(key, start, end);
            return set;
        }
    }
}

