/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.raincat.common.netty.serizlize.hessian;

import com.google.common.io.Closer;
import io.netty.buffer.ByteBuf;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import org.dromara.raincat.common.netty.MessageCodecService;
import org.dromara.raincat.common.netty.serizlize.hessian.HessianSerialize;
import org.dromara.raincat.common.netty.serizlize.hessian.HessianSerializePool;

public class HessianCodecServiceImpl
implements MessageCodecService {
    private static Closer closer = Closer.create();
    private HessianSerializePool pool = HessianSerializePool.getHessianPoolInstance();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void encode(ByteBuf out, Object message) throws IOException {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            closer.register((Closeable)byteArrayOutputStream);
            HessianSerialize hessianSerialization = this.pool.borrow();
            hessianSerialization.serialize(byteArrayOutputStream, message);
            byte[] body = byteArrayOutputStream.toByteArray();
            int dataLength = body.length;
            out.writeInt(dataLength);
            out.writeBytes(body);
            this.pool.restore(hessianSerialization);
        }
        finally {
            closer.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object decode(byte[] body) throws IOException {
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(body);
            closer.register((Closeable)byteArrayInputStream);
            HessianSerialize hessianSerialization = this.pool.borrow();
            Object object = hessianSerialization.deserialize(byteArrayInputStream);
            this.pool.restore(hessianSerialization);
            Object object2 = object;
            return object2;
        }
        finally {
            closer.close();
        }
    }
}

