/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.raincat.common.netty.serizlize.protostuff;

import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.dromara.raincat.common.netty.serizlize.protostuff.ProtostuffSerialize;
import org.dromara.raincat.common.netty.serizlize.protostuff.ProtostuffSerializeFactory;

public class ProtostuffSerializePool {
    private static volatile ProtostuffSerializePool poolFactory;
    private GenericObjectPool<ProtostuffSerialize> protostuffPool = new GenericObjectPool((PooledObjectFactory)new ProtostuffSerializeFactory());

    private ProtostuffSerializePool() {
    }

    public ProtostuffSerializePool(int maxTotal, int minIdle, long maxWaitMillis, long minEvictableIdleTimeMillis) {
        GenericObjectPoolConfig config = new GenericObjectPoolConfig();
        config.setMaxTotal(maxTotal);
        config.setMinIdle(minIdle);
        config.setMaxWaitMillis(maxWaitMillis);
        config.setMinEvictableIdleTimeMillis(minEvictableIdleTimeMillis);
        this.protostuffPool.setConfig(config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ProtostuffSerializePool getProtostuffPoolInstance() {
        if (poolFactory != null) return poolFactory;
        Class<ProtostuffSerializePool> clazz = ProtostuffSerializePool.class;
        synchronized (ProtostuffSerializePool.class) {
            if (poolFactory != null) return poolFactory;
            poolFactory = new ProtostuffSerializePool();
            // ** MonitorExit[var0] (shouldn't be in output)
            return poolFactory;
        }
    }

    public ProtostuffSerialize borrow() {
        try {
            return (ProtostuffSerialize)this.getProtostuffPool().borrowObject();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public void restore(ProtostuffSerialize object) {
        this.getProtostuffPool().returnObject((Object)object);
    }

    public GenericObjectPool<ProtostuffSerialize> getProtostuffPool() {
        return this.protostuffPool;
    }
}

