/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.raincat.common.serializer;

import com.caucho.hessian.io.Hessian2Input;
import com.caucho.hessian.io.Hessian2Output;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.dromara.raincat.annotation.RaincatSPI;
import org.dromara.raincat.common.exception.TransactionException;
import org.dromara.raincat.common.serializer.ObjectSerializer;

@RaincatSPI(value="hessian")
public class HessianSerializer
implements ObjectSerializer {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] serialize(Object obj) throws TransactionException {
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            Hessian2Output hos = new Hessian2Output((OutputStream)bos);
            hos.writeObject(obj);
            hos.flush();
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
        catch (IOException ex) {
            throw new TransactionException("Hessian serialize error " + ex.getMessage());
        }
    }

    @Override
    public <T> T deSerialize(byte[] param, Class<T> clazz) throws TransactionException {
        try {
            ByteArrayInputStream bios = new ByteArrayInputStream(param);
            Hessian2Input his = new Hessian2Input((InputStream)bios);
            return (T)his.readObject();
        }
        catch (IOException e) {
            throw new TransactionException("Hessian deSerialize error " + e.getMessage());
        }
    }
}

