/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.raincat.dubbo.interceptor;

import com.alibaba.dubbo.rpc.RpcContext;
import org.aspectj.lang.ProceedingJoinPoint;
import org.dromara.raincat.core.interceptor.TxTransactionInterceptor;
import org.dromara.raincat.core.service.AspectTransactionService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DubboTxTransactionInterceptor
implements TxTransactionInterceptor {
    private final AspectTransactionService aspectTransactionService;

    @Autowired
    public DubboTxTransactionInterceptor(AspectTransactionService aspectTransactionService) {
        this.aspectTransactionService = aspectTransactionService;
    }

    public Object interceptor(ProceedingJoinPoint pjp) throws Throwable {
        String groupId = RpcContext.getContext().getAttachment("Tx-Transaction-Group");
        return this.aspectTransactionService.invoke(groupId, pjp);
    }
}

