/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.raincat.manager.concurrent;

import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.dromara.raincat.manager.concurrent.CountDownThread;
import org.dromara.raincat.manager.concurrent.IExecute;

public class CountDownLatchHelper<T> {
    private static volatile boolean isExecute = false;
    private final List<T> data;
    private CountDownLatch end;
    private ExecutorService threadPool = null;
    private List<IExecute<T>> executes = Lists.newCopyOnWriteArrayList();
    private static ThreadFactory namedThreadFactory = new ThreadFactoryBuilder().setNameFormat("demo-pool-%d").build();

    public CountDownLatchHelper() {
        this.data = Lists.newCopyOnWriteArrayList();
        this.threadPool = new ThreadPoolExecutor(Runtime.getRuntime().availableProcessors(), Runtime.getRuntime().availableProcessors(), 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(1024), namedThreadFactory, new ThreadPoolExecutor.AbortPolicy());
    }

    public CountDownLatchHelper<T> addExecute(IExecute<T> execute) {
        this.executes.add(execute);
        return this;
    }

    public CountDownLatchHelper<T> execute() {
        int count = this.executes.size();
        if (count > 0) {
            this.end = new CountDownLatch(count);
            for (IExecute countDown : this.executes) {
                CountDownThread countDownThread = new CountDownThread(this.threadPool, this.data, countDown, this.end);
                countDownThread.execute();
            }
            try {
                this.end.await();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        this.threadPool.shutdown();
        isExecute = true;
        return this;
    }

    public List<T> getData() {
        if (!isExecute) {
            throw new RuntimeException("no execute !");
        }
        return this.data;
    }
}

