/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.raincat.manager.controller;

import java.util.List;
import org.dromara.raincat.common.entity.TxManagerServer;
import org.dromara.raincat.common.entity.TxManagerServiceDTO;
import org.dromara.raincat.common.netty.bean.TxTransactionItem;
import org.dromara.raincat.manager.entity.TxManagerInfo;
import org.dromara.raincat.manager.service.TxManagerInfoService;
import org.dromara.raincat.manager.service.execute.HttpTransactionExecutor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/tx/manager"})
public class TxManagerController {
    private final TxManagerInfoService txManagerInfoService;
    private final HttpTransactionExecutor httpTransactionExecutor;

    @Autowired
    public TxManagerController(TxManagerInfoService txManagerInfoService, HttpTransactionExecutor transactionExecutor) {
        this.txManagerInfoService = txManagerInfoService;
        this.httpTransactionExecutor = transactionExecutor;
    }

    @ResponseBody
    @PostMapping(value={"/findTxManagerServer"})
    public TxManagerServer findTxManagerServer() {
        return this.txManagerInfoService.findTxManagerServer();
    }

    @ResponseBody
    @PostMapping(value={"/loadTxManagerService"})
    public List<TxManagerServiceDTO> loadTxManagerService() {
        return this.txManagerInfoService.loadTxManagerService();
    }

    @RequestMapping(value={"/findTxManagerInfo"})
    public TxManagerInfo findTxManagerInfo() {
        return this.txManagerInfoService.findTxManagerInfo();
    }

    @PostMapping(value={"/httpCommit"})
    public void httpCommit(@RequestBody List<TxTransactionItem> items) {
        this.httpTransactionExecutor.commit(items);
    }

    @PostMapping(value={"/httpRollBack"})
    public void httpRollBack(@RequestBody List<TxTransactionItem> items) {
        this.httpTransactionExecutor.rollBack(items);
    }
}

