/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.raincat.manager.netty.handler;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.concurrent.DefaultEventExecutorGroup;
import java.util.concurrent.TimeUnit;
import org.dromara.raincat.common.enums.SerializeProtocolEnum;
import org.dromara.raincat.common.netty.NettyPipelineInit;
import org.dromara.raincat.manager.config.NettyConfig;
import org.dromara.raincat.manager.netty.handler.NettyServerMessageHandler;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class NettyServerHandlerInitializer
extends ChannelInitializer<SocketChannel> {
    private final NettyConfig nettyConfig;
    private final NettyServerMessageHandler nettyServerMessageHandler;
    private SerializeProtocolEnum serializeProtocolEnum;
    private DefaultEventExecutorGroup servletExecutor;

    @Autowired
    public NettyServerHandlerInitializer(NettyConfig nettyConfig, NettyServerMessageHandler nettyServerMessageHandler) {
        this.nettyConfig = nettyConfig;
        this.nettyServerMessageHandler = nettyServerMessageHandler;
    }

    public void setServletExecutor(DefaultEventExecutorGroup servletExecutor) {
        this.servletExecutor = servletExecutor;
    }

    public void setSerializeProtocolEnum(SerializeProtocolEnum serializeProtocolEnum) {
        this.serializeProtocolEnum = serializeProtocolEnum;
    }

    protected void initChannel(SocketChannel ch) {
        ChannelPipeline pipeline = ch.pipeline();
        NettyPipelineInit.serializePipeline((SerializeProtocolEnum)this.serializeProtocolEnum, (ChannelPipeline)pipeline);
        pipeline.addLast("timeout", (ChannelHandler)new IdleStateHandler((long)this.nettyConfig.getHeartTime(), (long)this.nettyConfig.getHeartTime(), (long)this.nettyConfig.getHeartTime(), TimeUnit.SECONDS));
        pipeline.addLast(new ChannelHandler[]{this.nettyServerMessageHandler});
    }
}

