/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.raincat.manager.netty.handler;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.util.ReferenceCountUtil;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.dromara.raincat.common.enums.NettyMessageActionEnum;
import org.dromara.raincat.common.enums.NettyResultEnum;
import org.dromara.raincat.common.holder.LogUtil;
import org.dromara.raincat.common.netty.bean.HeartBeat;
import org.dromara.raincat.common.netty.bean.TxTransactionGroup;
import org.dromara.raincat.common.netty.bean.TxTransactionItem;
import org.dromara.raincat.manager.config.Address;
import org.dromara.raincat.manager.netty.handler.NettyServerMessageHandler;
import org.dromara.raincat.manager.service.TxManagerService;
import org.dromara.raincat.manager.service.TxTransactionExecutor;
import org.dromara.raincat.manager.socket.SocketManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@ChannelHandler.Sharable
@Component
public class NettyServerMessageHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(NettyServerMessageHandler.class);
    private final TxManagerService txManagerService;
    private final TxTransactionExecutor txTransactionExecutor;

    @Autowired
    public NettyServerMessageHandler(TxManagerService txManagerService, TxTransactionExecutor txTransactionExecutor) {
        this.txManagerService = txManagerService;
        this.txTransactionExecutor = txTransactionExecutor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        HeartBeat hb = (HeartBeat)msg;
        TxTransactionGroup txTransactionGroup = hb.getTxTransactionGroup();
        try {
            NettyMessageActionEnum actionEnum = NettyMessageActionEnum.acquireByCode((int)hb.getAction());
            LogUtil.debug((Logger)LOGGER, (String)"receive client date this action:{}", () -> ((NettyMessageActionEnum)actionEnum).getDesc());
            switch (1.$SwitchMap$org$dromara$raincat$common$enums$NettyMessageActionEnum[actionEnum.ordinal()]) {
                case 1: {
                    hb.setAction(NettyMessageActionEnum.HEART.getCode());
                    ctx.writeAndFlush((Object)hb);
                    return;
                }
                case 2: {
                    List items = txTransactionGroup.getItemList();
                    if (CollectionUtils.isNotEmpty((Collection)items)) {
                        String modelName = ctx.channel().remoteAddress().toString();
                        TxTransactionItem item = (TxTransactionItem)items.get(1);
                        item.setModelName(modelName);
                        item.setTmDomain(Address.getInstance().getDomain());
                    }
                    Boolean success = this.txManagerService.saveTxTransactionGroup(txTransactionGroup);
                    ctx.writeAndFlush((Object)this.buildSendMessage(hb.getKey(), success));
                    return;
                }
                case 3: {
                    List itemList = txTransactionGroup.getItemList();
                    if (!CollectionUtils.isNotEmpty((Collection)itemList)) return;
                    String modelName = ctx.channel().remoteAddress().toString();
                    TxTransactionItem item = (TxTransactionItem)itemList.get(0);
                    item.setModelName(modelName);
                    item.setTmDomain(Address.getInstance().getDomain());
                    Boolean success = this.txManagerService.addTxTransaction(txTransactionGroup.getId(), item);
                    ctx.writeAndFlush((Object)this.buildSendMessage(hb.getKey(), success));
                    return;
                }
                case 4: {
                    int status = this.txManagerService.findTxTransactionGroupStatus(txTransactionGroup.getId());
                    txTransactionGroup.setStatus(status);
                    hb.setTxTransactionGroup(txTransactionGroup);
                    ctx.writeAndFlush((Object)hb);
                    return;
                }
                case 5: {
                    List txTransactionItems = this.txManagerService.listByTxGroupId(txTransactionGroup.getId());
                    txTransactionGroup.setItemList(txTransactionItems);
                    hb.setTxTransactionGroup(txTransactionGroup);
                    ctx.writeAndFlush((Object)hb);
                    return;
                }
                case 6: {
                    ctx.writeAndFlush((Object)this.buildSendMessage(hb.getKey(), Boolean.valueOf(true)));
                    String groupId = txTransactionGroup.getId();
                    this.txTransactionExecutor.rollBack(groupId);
                    return;
                }
                case 7: {
                    ctx.writeAndFlush((Object)this.buildSendMessage(hb.getKey(), Boolean.valueOf(true)));
                    this.txTransactionExecutor.preCommit(txTransactionGroup.getId());
                    return;
                }
                case 8: {
                    List its = txTransactionGroup.getItemList();
                    if (!CollectionUtils.isNotEmpty((Collection)its)) return;
                    TxTransactionItem item = (TxTransactionItem)its.get(0);
                    this.txManagerService.updateTxTransactionItemStatus(txTransactionGroup.getId(), item.getTaskKey(), item.getStatus(), item.getMessage());
                    return;
                }
                default: {
                    hb.setAction(NettyMessageActionEnum.HEART.getCode());
                    ctx.writeAndFlush((Object)hb);
                    return;
                }
            }
        }
        finally {
            ReferenceCountUtil.release((Object)msg);
        }
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        super.channelActive(ctx);
        if (SocketManager.getInstance().isAllowConnection()) {
            SocketManager.getInstance().addClient(ctx.channel());
        } else {
            ctx.close();
        }
    }

    public void channelRegistered(ChannelHandlerContext ctx) throws Exception {
        super.channelRegistered(ctx);
    }

    public void channelUnregistered(ChannelHandlerContext ctx) throws Exception {
        SocketManager.getInstance().removeClient(ctx.channel());
        super.channelUnregistered(ctx);
    }

    public void channelReadComplete(ChannelHandlerContext ctx) {
        ctx.flush();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        cause.printStackTrace();
        ctx.close();
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
        IdleStateEvent event;
        if (IdleStateEvent.class.isAssignableFrom(evt.getClass()) && (event = (IdleStateEvent)evt).state() == IdleState.READER_IDLE) {
            ctx.close();
        }
    }

    private HeartBeat buildSendMessage(String key, Boolean success) {
        HeartBeat heartBeat = new HeartBeat();
        heartBeat.setKey(key);
        heartBeat.setAction(NettyMessageActionEnum.RECEIVE.getCode());
        if (success.booleanValue()) {
            heartBeat.setResult(NettyResultEnum.SUCCESS.getCode());
        } else {
            heartBeat.setResult(NettyResultEnum.FAIL.getCode());
        }
        return heartBeat;
    }
}

