/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.raincat.manager.netty.impl;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.EpollChannelOption;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.util.concurrent.DefaultEventExecutorGroup;
import org.dromara.raincat.common.enums.SerializeProtocolEnum;
import org.dromara.raincat.common.exception.TransactionRuntimeException;
import org.dromara.raincat.manager.config.NettyConfig;
import org.dromara.raincat.manager.netty.NettyService;
import org.dromara.raincat.manager.netty.handler.NettyServerHandlerInitializer;
import org.dromara.raincat.manager.socket.SocketManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class NettyServerServiceImpl
implements NettyService,
DisposableBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(NettyServerServiceImpl.class);
    private static int maxThread = Runtime.getRuntime().availableProcessors() << 1;
    private EventLoopGroup bossGroup;
    private EventLoopGroup workerGroup;
    private DefaultEventExecutorGroup servletExecutor;
    private final NettyConfig nettyConfig;
    private final NettyServerHandlerInitializer nettyServerHandlerInitializer;

    @Autowired(required=false)
    public NettyServerServiceImpl(NettyConfig nettyConfig, NettyServerHandlerInitializer nettyServerHandlerInitializer) {
        this.nettyConfig = nettyConfig;
        this.nettyServerHandlerInitializer = nettyServerHandlerInitializer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws InterruptedException {
        SocketManager.getInstance().setMaxConnection(this.nettyConfig.getMaxConnection());
        if (this.nettyConfig.getMaxThreads() != 0) {
            maxThread = this.nettyConfig.getMaxThreads();
        }
        this.servletExecutor = new DefaultEventExecutorGroup(maxThread);
        SerializeProtocolEnum serializeProtocolEnum = SerializeProtocolEnum.acquireSerializeProtocol((String)this.nettyConfig.getSerialize());
        this.nettyServerHandlerInitializer.setSerializeProtocolEnum(serializeProtocolEnum);
        this.nettyServerHandlerInitializer.setServletExecutor(this.servletExecutor);
        ServerBootstrap b = new ServerBootstrap();
        this.bossGroup = this.createEventLoopGroup();
        if (this.bossGroup instanceof EpollEventLoopGroup) {
            this.groupsEpoll(b, maxThread);
        } else {
            this.groupsNio(b, maxThread);
        }
        try {
            LOGGER.info("netty service started on port: " + this.nettyConfig.getPort());
            ChannelFuture future = b.bind(this.nettyConfig.getPort()).sync();
            future.channel().closeFuture().sync();
        }
        finally {
            this.workerGroup.shutdownGracefully();
            this.bossGroup.shutdownGracefully();
            this.servletExecutor.shutdownGracefully();
        }
    }

    private EventLoopGroup createEventLoopGroup() {
        try {
            return new EpollEventLoopGroup(1);
        }
        catch (Throwable ex) {
            return new NioEventLoopGroup(1);
        }
    }

    private void groupsEpoll(ServerBootstrap bootstrap, int workThreads) {
        this.workerGroup = new EpollEventLoopGroup(workThreads);
        ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)bootstrap.group(this.bossGroup, this.workerGroup).channel(EpollServerSocketChannel.class)).option(EpollChannelOption.TCP_CORK, (Object)true)).option(EpollChannelOption.SO_KEEPALIVE, (Object)true)).option(EpollChannelOption.SO_BACKLOG, (Object)100)).option(EpollChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT)).childOption(EpollChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT).handler((ChannelHandler)new LoggingHandler(LogLevel.INFO))).childHandler((ChannelHandler)this.nettyServerHandlerInitializer);
    }

    private void groupsNio(ServerBootstrap bootstrap, int workThreads) {
        this.workerGroup = new NioEventLoopGroup(workThreads);
        ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)bootstrap.group(this.bossGroup, this.workerGroup).channel(NioServerSocketChannel.class)).option(EpollChannelOption.TCP_CORK, (Object)true)).option(EpollChannelOption.SO_KEEPALIVE, (Object)true)).option(EpollChannelOption.SO_BACKLOG, (Object)100)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)100)).option(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT)).childOption(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT).handler((ChannelHandler)new LoggingHandler(LogLevel.INFO))).childHandler((ChannelHandler)this.nettyServerHandlerInitializer);
    }

    private void stop() {
        try {
            if (null != this.bossGroup) {
                this.bossGroup.shutdownGracefully().await();
            }
            if (null != this.workerGroup) {
                this.workerGroup.shutdownGracefully().await();
            }
            if (null != this.servletExecutor) {
                this.servletExecutor.shutdownGracefully().await();
            }
        }
        catch (InterruptedException e) {
            throw new TransactionRuntimeException(" Netty  Container stop interrupted", (Throwable)e);
        }
    }

    public void destroy() {
        this.stop();
    }
}

