/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.raincat.manager.service.execute;

import io.netty.channel.Channel;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.dromara.raincat.common.enums.TransactionRoleEnum;
import org.dromara.raincat.common.enums.TransactionStatusEnum;
import org.dromara.raincat.common.holder.LogUtil;
import org.dromara.raincat.common.netty.bean.TxTransactionItem;
import org.dromara.raincat.manager.config.Address;
import org.dromara.raincat.manager.service.TxManagerService;
import org.dromara.raincat.manager.service.TxTransactionExecutor;
import org.dromara.raincat.manager.socket.SocketManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTxTransactionExecutor
implements TxTransactionExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractTxTransactionExecutor.class);
    private TxManagerService txManagerService;

    protected abstract void doRollBack(String var1, List<TxTransactionItem> var2, List<TxTransactionItem> var3);

    protected abstract void doCommit(String var1, List<TxTransactionItem> var2, List<TxTransactionItem> var3);

    public void setTxManagerService(TxManagerService txManagerService) {
        this.txManagerService = txManagerService;
    }

    public void rollBack(String txGroupId) {
        this.txManagerService.updateTxTransactionItemStatus(txGroupId, txGroupId, TransactionStatusEnum.ROLLBACK.getCode(), null);
        List txTransactionItems = this.txManagerService.listByTxGroupId(txGroupId);
        if (CollectionUtils.isNotEmpty((Collection)txTransactionItems)) {
            Map listMap = this.filterData(txTransactionItems);
            if (Objects.isNull(listMap)) {
                LogUtil.info((Logger)LOGGER, (String)"\u4e8b\u52a1\u7ec4id:{},\u63d0\u4ea4\u5931\u8d25\uff01\u6570\u636e\u4e0d\u5b8c\u6574", () -> txGroupId);
                return;
            }
            List currentItem = (List)listMap.get(Boolean.TRUE);
            List elseItems = (List)listMap.get(Boolean.FALSE);
            this.doRollBack(txGroupId, currentItem, elseItems);
        }
    }

    public void preCommit(String txGroupId) {
        this.txManagerService.updateTxTransactionItemStatus(txGroupId, txGroupId, TransactionStatusEnum.COMMIT.getCode(), null);
        List txTransactionItems = this.txManagerService.listByTxGroupId(txGroupId);
        Map listMap = this.filterData(txTransactionItems);
        if (Objects.isNull(listMap)) {
            LogUtil.info((Logger)LOGGER, (String)"\u4e8b\u52a1\u7ec4id:{},\u63d0\u4ea4\u5931\u8d25\uff01\u6570\u636e\u4e0d\u5b8c\u6574", () -> txGroupId);
            return;
        }
        List currentItem = (List)listMap.get(Boolean.TRUE);
        List elseItems = (List)listMap.get(Boolean.FALSE);
        Boolean ok = this.checkChannel(currentItem);
        if (!ok.booleanValue()) {
            this.doRollBack(txGroupId, currentItem, elseItems);
        } else {
            this.doCommit(txGroupId, currentItem, elseItems);
        }
    }

    private Boolean checkChannel(List<TxTransactionItem> txTransactionItems) {
        if (CollectionUtils.isNotEmpty(txTransactionItems)) {
            List collect = txTransactionItems.stream().filter(item -> {
                Channel channel = SocketManager.getInstance().getChannelByModelName(item.getModelName());
                return Objects.nonNull(channel) && (channel.isActive() || item.getStatus() != TransactionStatusEnum.ROLLBACK.getCode());
            }).collect(Collectors.toList());
            return txTransactionItems.size() == collect.size();
        }
        return true;
    }

    private Map<Boolean, List<TxTransactionItem>> filterData(List<TxTransactionItem> txTransactionItems) {
        List collect = txTransactionItems.stream().filter(item -> item.getRole() == TransactionRoleEnum.ACTOR.getCode()).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(collect)) {
            return null;
        }
        return collect.stream().collect(Collectors.partitioningBy(item -> Objects.equals(Address.getInstance().getDomain(), item.getTmDomain())));
    }
}

