/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.raincat.manager.service.execute;

import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.collections.CollectionUtils;
import org.dromara.raincat.common.enums.TransactionStatusEnum;
import org.dromara.raincat.common.holder.LogUtil;
import org.dromara.raincat.common.netty.bean.HeartBeat;
import org.dromara.raincat.common.netty.bean.TxTransactionItem;
import org.dromara.raincat.manager.config.ChannelSender;
import org.dromara.raincat.manager.config.ExecutorMessageTool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class HttpTransactionExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpTransactionExecutor.class);

    public void rollBack(List<TxTransactionItem> txTransactionItems) {
        try {
            this.execute(txTransactionItems, TransactionStatusEnum.ROLLBACK);
        }
        catch (Exception e) {
            e.printStackTrace();
            LogUtil.info((Logger)LOGGER, (String)"txManger \u53d1\u9001rollback\u6307\u4ee4\u5f02\u5e38 ", e::getMessage);
        }
    }

    public void commit(List<TxTransactionItem> txTransactionItems) {
        try {
            this.execute(txTransactionItems, TransactionStatusEnum.COMMIT);
        }
        catch (Exception e) {
            e.printStackTrace();
            LogUtil.info((Logger)LOGGER, (String)"txManger \u53d1\u9001commit \u6307\u4ee4\u5f02\u5e38 ", e::getMessage);
        }
    }

    private void execute(List<TxTransactionItem> txTransactionItems, TransactionStatusEnum transactionStatusEnum) {
        if (CollectionUtils.isNotEmpty(txTransactionItems)) {
            CompletableFuture[] cfs = (CompletableFuture[])txTransactionItems.stream().map(item -> CompletableFuture.runAsync(() -> {
                ChannelSender channelSender = new ChannelSender();
                HeartBeat heartBeat = ExecutorMessageTool.buildMessage((TxTransactionItem)item, (ChannelSender)channelSender, (TransactionStatusEnum)transactionStatusEnum);
                if (Objects.nonNull(channelSender.getChannel())) {
                    channelSender.getChannel().writeAndFlush((Object)heartBeat);
                } else {
                    LOGGER.error("txMange {},\u6307\u4ee4\u5931\u8d25\uff0cchannel\u4e3a\u7a7a\uff0c\u4e8b\u52a1\u7ec4id\uff1a{}, \u4e8b\u52a1taskId\u4e3a:{}", new Object[]{transactionStatusEnum.getDesc(), item.getTxGroupId(), item.getTaskKey()});
                }
            }).whenComplete((v, e) -> LOGGER.info("txManger \u6210\u529f\u53d1\u9001 {} \u6307\u4ee4 \u4e8b\u52a1taskId\u4e3a\uff1a{}", (Object)transactionStatusEnum.getDesc(), (Object)item.getTaskKey()))).toArray(CompletableFuture[]::new);
            CompletableFuture.allOf(cfs).join();
        }
    }
}

