/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.raincat.manager.service.execute;

import com.google.gson.Gson;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.dromara.raincat.common.enums.TransactionStatusEnum;
import org.dromara.raincat.common.holder.LogUtil;
import org.dromara.raincat.common.holder.httpclient.OkHttpTools;
import org.dromara.raincat.common.netty.bean.HeartBeat;
import org.dromara.raincat.common.netty.bean.TxTransactionItem;
import org.dromara.raincat.manager.config.ChannelSender;
import org.dromara.raincat.manager.config.ExecutorMessageTool;
import org.dromara.raincat.manager.service.TxManagerService;
import org.dromara.raincat.manager.service.execute.AbstractTxTransactionExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TxTransactionExecutorService
extends AbstractTxTransactionExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(TxTransactionExecutorService.class);
    private static final Gson GSON = new Gson();

    @Autowired
    public TxTransactionExecutorService(TxManagerService txManagerService) {
        super.setTxManagerService(txManagerService);
    }

    protected void doRollBack(String txGroupId, List<TxTransactionItem> txTransactionItems, List<TxTransactionItem> elseItems) {
        try {
            if (CollectionUtils.isNotEmpty(txTransactionItems)) {
                CompletableFuture[] cfs = (CompletableFuture[])txTransactionItems.stream().map(item -> CompletableFuture.runAsync(() -> {
                    ChannelSender channelSender = new ChannelSender();
                    HeartBeat heartBeat = ExecutorMessageTool.buildMessage((TxTransactionItem)item, (ChannelSender)channelSender, (TransactionStatusEnum)TransactionStatusEnum.ROLLBACK);
                    if (Objects.nonNull(channelSender.getChannel())) {
                        channelSender.getChannel().writeAndFlush((Object)heartBeat);
                    } else {
                        LOGGER.error("txManger rollback\u6307\u4ee4\u5931\u8d25\uff0cchannel\u4e3a\u7a7a\uff0c\u4e8b\u52a1\u7ec4id\uff1a{}, \u4e8b\u52a1taskId\u4e3a:{}", (Object)txGroupId, (Object)item.getTaskKey());
                    }
                }).whenComplete((v, e) -> LogUtil.info((Logger)LOGGER, (String)"txManger \u6210\u529f\u53d1\u9001rollback\u6307\u4ee4 \u4e8b\u52a1taskId\u4e3a\uff1a{}", () -> ((TxTransactionItem)item).getTaskKey()))).toArray(CompletableFuture[]::new);
                CompletableFuture.allOf(cfs).join();
                LogUtil.info((Logger)LOGGER, (String)"txManger \u6210\u529f\u53d1\u9001rollback\u6307\u4ee4 \u4e8b\u52a1\u7ec4id\u4e3a\uff1a{}", () -> txGroupId);
            }
            this.httpExecute(elseItems, TransactionStatusEnum.ROLLBACK);
        }
        catch (Exception e) {
            e.printStackTrace();
            LogUtil.info((Logger)LOGGER, (String)"txManger \u53d1\u9001rollback\u6307\u4ee4\u5f02\u5e38 ", e::getMessage);
        }
    }

    protected void doCommit(String txGroupId, List<TxTransactionItem> txTransactionItems, List<TxTransactionItem> elseItems) {
        try {
            txTransactionItems.forEach(item -> {
                ChannelSender sender = new ChannelSender();
                HeartBeat heartBeat = ExecutorMessageTool.buildMessage((TxTransactionItem)item, (ChannelSender)sender, (TransactionStatusEnum)TransactionStatusEnum.COMMIT);
                if (Objects.nonNull(sender.getChannel())) {
                    sender.getChannel().writeAndFlush((Object)heartBeat);
                    LogUtil.info((Logger)LOGGER, (String)"txManger \u6210\u529f\u53d1\u9001doCommit\u6307\u4ee4 \u4e8b\u52a1taskId\u4e3a\uff1a{}", () -> ((TxTransactionItem)item).getTaskKey());
                } else {
                    LOGGER.error("txManger \u53d1\u9001doCommit\u6307\u4ee4\u5931\u8d25\uff0cchannel\u4e3a\u7a7a\uff0c\u4e8b\u52a1\u7ec4id\uff1a{}, \u4e8b\u52a1taskId\u4e3a:{}", (Object)txGroupId, (Object)item.getTaskKey());
                }
            });
            this.httpExecute(elseItems, TransactionStatusEnum.COMMIT);
        }
        catch (Exception e) {
            e.printStackTrace();
            LogUtil.info((Logger)LOGGER, (String)"txManger \u53d1\u9001doCommit\u6307\u4ee4\u5f02\u5e38 ", e::getMessage);
        }
    }

    private void httpExecute(List<TxTransactionItem> elseItems, TransactionStatusEnum transactionStatusEnum) {
        if (CollectionUtils.isNotEmpty(elseItems)) {
            Map<String, List<TxTransactionItem>> senderItems = elseItems.stream().collect(Collectors.groupingBy(TxTransactionItem::getTmDomain));
            senderItems.forEach((k, v) -> {
                try {
                    if (transactionStatusEnum.getCode() == TransactionStatusEnum.COMMIT.getCode()) {
                        OkHttpTools.getInstance().post(String.format("http://%s/tx/manager/httpCommit", k), GSON.toJson(v));
                    } else if (transactionStatusEnum.getCode() == TransactionStatusEnum.ROLLBACK.getCode()) {
                        OkHttpTools.getInstance().post(String.format("http://%s/tx/manager/httpRollBack", k), GSON.toJson(v));
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
        }
    }
}

