/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.raincat.manager.service.impl;

import com.netflix.appinfo.InstanceInfo;
import com.netflix.eureka.EurekaServerContextHolder;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.dromara.raincat.common.entity.TxManagerServer;
import org.dromara.raincat.common.entity.TxManagerServiceDTO;
import org.dromara.raincat.manager.config.NettyConfig;
import org.dromara.raincat.manager.entity.TxManagerInfo;
import org.dromara.raincat.manager.eureka.DiscoveryService;
import org.dromara.raincat.manager.service.TxManagerInfoService;
import org.dromara.raincat.manager.socket.SocketManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@Service(value="txManagerInfoService")
public class TxManagerInfoServiceImpl
implements TxManagerInfoService {
    private final DiscoveryService discoveryService;
    private final NettyConfig nettyConfig;
    private final RestTemplate restTemplate;
    @Value(value="${redisSaveMaxTime}")
    private int redisSaveMaxTime;
    @Value(value="${transactionWaitMaxTime}")
    private int transactionWaitMaxTime;

    @Autowired(required=false)
    public TxManagerInfoServiceImpl(DiscoveryService discoveryService, NettyConfig nettyConfig, RestTemplate restTemplate) {
        this.discoveryService = discoveryService;
        this.nettyConfig = nettyConfig;
        this.restTemplate = restTemplate;
    }

    public TxManagerServer findTxManagerServer() {
        Optional<TxManagerInfo> txManagerInfoOptional;
        List txManagerList;
        List eurekaService = this.findEurekaService();
        if (CollectionUtils.isNotEmpty((Collection)eurekaService) && CollectionUtils.isNotEmpty(txManagerList = eurekaService.stream().map(url -> (TxManagerInfo)this.restTemplate.getForObject(url + "/tx/manager/findTxManagerInfo", TxManagerInfo.class, new Object[0])).collect(Collectors.toList())) && (txManagerInfoOptional = txManagerList.stream().filter(Objects::nonNull).filter(info -> info.getNowConnection() < info.getMaxConnection()).max(Comparator.comparingInt(TxManagerInfo::getNowConnection))).isPresent()) {
            TxManagerInfo txManagerInfo = txManagerInfoOptional.get();
            TxManagerServer txManagerServer = new TxManagerServer();
            txManagerServer.setHost(txManagerInfo.getIp());
            txManagerServer.setPort(Integer.valueOf(txManagerInfo.getPort()));
            return txManagerServer;
        }
        return null;
    }

    public TxManagerInfo findTxManagerInfo() {
        TxManagerInfo txManagerInfo = new TxManagerInfo();
        String ip = EurekaServerContextHolder.getInstance().getServerContext().getApplicationInfoManager().getEurekaInstanceConfig().getIpAddress();
        txManagerInfo.setIp(ip);
        txManagerInfo.setPort(this.nettyConfig.getPort());
        txManagerInfo.setMaxConnection(SocketManager.getInstance().getMaxConnection());
        txManagerInfo.setNowConnection(SocketManager.getInstance().getNowConnection());
        txManagerInfo.setTransactionWaitMaxTime(this.transactionWaitMaxTime);
        txManagerInfo.setRedisSaveMaxTime(this.redisSaveMaxTime);
        txManagerInfo.setClusterInfoList(this.findEurekaService());
        return txManagerInfo;
    }

    public List<TxManagerServiceDTO> loadTxManagerService() {
        List instanceInfoList = this.discoveryService.getConfigServiceInstances();
        return instanceInfoList.stream().map(instanceInfo -> {
            TxManagerServiceDTO dto = new TxManagerServiceDTO();
            dto.setAppName(instanceInfo.getAppName());
            dto.setInstanceId(instanceInfo.getInstanceId());
            dto.setHomepageUrl(instanceInfo.getHomePageUrl());
            return dto;
        }).collect(Collectors.toList());
    }

    private List<String> findEurekaService() {
        List configServiceInstances = this.discoveryService.getConfigServiceInstances();
        return configServiceInstances.stream().map(InstanceInfo::getHomePageUrl).collect(Collectors.toList());
    }
}

