/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.raincat.manager.service.impl;

import java.text.ParseException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.dromara.raincat.common.enums.TransactionRoleEnum;
import org.dromara.raincat.common.enums.TransactionStatusEnum;
import org.dromara.raincat.common.holder.DateUtils;
import org.dromara.raincat.common.netty.bean.TxTransactionGroup;
import org.dromara.raincat.common.netty.bean.TxTransactionItem;
import org.dromara.raincat.manager.service.TxManagerService;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

@Component
public class TxManagerServiceImpl
implements TxManagerService {
    private final RedisTemplate redisTemplate;

    @Autowired
    public TxManagerServiceImpl(RedisTemplate redisTemplate) {
        this.redisTemplate = redisTemplate;
    }

    public Boolean saveTxTransactionGroup(TxTransactionGroup txTransactionGroup) {
        try {
            String groupId = txTransactionGroup.getId();
            this.redisTemplate.opsForZSet().add((Object)"transaction:group", (Object)groupId, 10.0);
            List itemList = txTransactionGroup.getItemList();
            if (CollectionUtils.isNotEmpty((Collection)itemList)) {
                for (TxTransactionItem item : itemList) {
                    this.redisTemplate.opsForHash().put((Object)this.cacheKey(groupId), (Object)item.getTaskKey(), (Object)item);
                }
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public Boolean addTxTransaction(String txGroupId, TxTransactionItem txTransactionItem) {
        try {
            this.redisTemplate.opsForHash().put((Object)this.cacheKey(txGroupId), (Object)txTransactionItem.getTaskKey(), (Object)txTransactionItem);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public List<TxTransactionItem> listByTxGroupId(String txGroupId) {
        Map entries = this.redisTemplate.opsForHash().entries((Object)this.cacheKey(txGroupId));
        Collection values = entries.values();
        return new ArrayList<TxTransactionItem>(values);
    }

    public void removeRedisByTxGroupId(String txGroupId) {
        this.redisTemplate.delete((Object)this.cacheKey(txGroupId));
    }

    public void updateTxTransactionItemStatus(String key, String hashKey, int status, Object message) {
        try {
            TxTransactionItem item = (TxTransactionItem)this.redisTemplate.opsForHash().get((Object)this.cacheKey(key), (Object)hashKey);
            item.setStatus(status);
            if (Objects.nonNull(message)) {
                item.setMessage(message);
            }
            String createDate = item.getCreateDate();
            LocalDateTime now = LocalDateTime.now();
            try {
                LocalDateTime createDateTime = DateUtils.parseLocalDateTime((String)createDate);
                long consumeTime = DateUtils.getSecondsBetween((LocalDateTime)createDateTime, (LocalDateTime)now);
                item.setConsumeTime(Long.valueOf(consumeTime));
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            this.redisTemplate.opsForHash().put((Object)this.cacheKey(key), (Object)item.getTaskKey(), (Object)item);
        }
        catch (BeansException e) {
            e.printStackTrace();
        }
    }

    public int findTxTransactionGroupStatus(String txGroupId) {
        try {
            TxTransactionItem item = (TxTransactionItem)this.redisTemplate.opsForHash().get((Object)this.cacheKey(txGroupId), (Object)txGroupId);
            return item.getStatus();
        }
        catch (BeansException e) {
            e.printStackTrace();
            return TransactionStatusEnum.ROLLBACK.getCode();
        }
    }

    public void removeCommitTxGroup() {
        Set keys = this.redisTemplate.keys((Object)"transaction:group:*");
        keys.parallelStream().forEach(key -> {
            Map entries = this.redisTemplate.opsForHash().entries(key);
            Collection values = entries.values();
            boolean present = values.stream().anyMatch(item -> item.getStatus() != TransactionStatusEnum.COMMIT.getCode());
            if (!present) {
                this.redisTemplate.delete(key);
            }
        });
    }

    public void removeRollBackTxGroup() {
        Set keys = this.redisTemplate.keys((Object)"transaction:group:*");
        keys.parallelStream().forEach(key -> {
            Map entries = this.redisTemplate.opsForHash().entries(key);
            Collection values = entries.values();
            Optional<TxTransactionItem> any = values.stream().filter(item -> item.getRole() == TransactionRoleEnum.START.getCode() && item.getStatus() == TransactionStatusEnum.ROLLBACK.getCode()).findAny();
            if (any.isPresent()) {
                this.redisTemplate.delete(key);
            }
        });
    }

    private String cacheKey(String key) {
        return String.format("transaction:group:%s", key);
    }
}

