/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.raincat.manager.socket;

import com.google.common.collect.Lists;
import io.netty.channel.Channel;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;

public final class SocketManager {
    private static SocketManager manager = new SocketManager();
    private int maxConnection = 50;
    private int nowConnection;
    private volatile boolean allowConnection = true;
    private List<Channel> clients = Lists.newCopyOnWriteArrayList();

    private SocketManager() {
    }

    public static SocketManager getInstance() {
        return manager;
    }

    public void setMaxConnection(int maxConnection) {
        this.maxConnection = maxConnection;
    }

    public Channel getChannelByModelName(String name) {
        if (CollectionUtils.isNotEmpty((Collection)this.clients)) {
            Optional<Channel> first = this.clients.stream().filter(channel -> Objects.equals(channel.remoteAddress().toString(), name)).findFirst();
            return first.orElse(null);
        }
        return null;
    }

    public void addClient(Channel client) {
        this.clients.add(client);
        this.nowConnection = this.clients.size();
        this.allowConnection = this.maxConnection != this.nowConnection;
    }

    public void removeClient(Channel client) {
        this.clients.remove(client);
        this.nowConnection = this.clients.size();
        this.allowConnection = this.maxConnection != this.nowConnection;
    }

    public int getMaxConnection() {
        return this.maxConnection;
    }

    public int getNowConnection() {
        return this.nowConnection;
    }

    public boolean isAllowConnection() {
        return this.allowConnection;
    }
}

