/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.raincat.manager.spring;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.dromara.raincat.manager.config.Address;
import org.springframework.boot.context.embedded.EmbeddedServletContainerInitializedEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;

@Component
public class ApplicationStartListener
implements ApplicationListener<EmbeddedServletContainerInitializedEvent> {
    public void onApplicationEvent(EmbeddedServletContainerInitializedEvent event) {
        int port = event.getEmbeddedServletContainer().getPort();
        String host = this.getHost();
        Address.getInstance().setHost(host).setPort(Integer.valueOf(port)).setDomain(String.join((CharSequence)":", host, String.valueOf(port)));
    }

    private String getHost() {
        try {
            return InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            return "127.0.0.1";
        }
    }
}

