package org.dromara.soul.bootstrap.cors;

import org.dromara.soul.common.utils.JsonUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthEndpoint;
import org.springframework.core.annotation.Order;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.stereotype.Component;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;
import reactor.util.annotation.Nullable;

import java.util.Objects;


/**
 * The type Health filter.
 *
 * @author xiaoyu
 * @author kl @kailing.pub
 */
@Component
@Order(-99)
public final class HealthFilter implements WebFilter {

    private static final String FILTER_TAG = "/actuator/health";

    private final HealthEndpoint healthEndpoint;

    @Autowired
    private HealthFilter(final HealthEndpoint endpoint) {
        healthEndpoint = endpoint;
    }

    @Override
    public Mono<Void> filter(@Nullable final ServerWebExchange exchange, @Nullable final WebFilterChain chain) {
        ServerHttpRequest request = Objects.requireNonNull(exchange).getRequest();
        String urlPath = request.getURI().getPath();
        if (FILTER_TAG.equals(urlPath)) {
            Health health = healthEndpoint.health();
            String result = Objects.requireNonNull(JsonUtils.toJson(health));
            DataBuffer dataBuffer = exchange.getResponse().bufferFactory().wrap(result.getBytes());
            return exchange.getResponse().writeWith(Mono.just(dataBuffer));
        }
        return Objects.requireNonNull(chain).filter(exchange);
    }

}
