/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.soul.client.common.utils;

import com.google.gson.Gson;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import okhttp3.FormBody;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public final class OkHttpTools {
    private static final MediaType JSON = MediaType.parse((String)"application/json; charset=utf-8");
    private static final OkHttpTools OK_HTTP_TOOLS = new OkHttpTools();
    private static final Gson GOSN = new Gson();
    private OkHttpClient client;

    private OkHttpTools() {
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        builder.connectTimeout(10L, TimeUnit.SECONDS);
        builder.readTimeout(10L, TimeUnit.SECONDS);
        builder.writeTimeout(10L, TimeUnit.SECONDS);
        this.client = builder.build();
    }

    public static OkHttpTools getInstance() {
        return OK_HTTP_TOOLS;
    }

    private Request buildPost(String url, Map<String, String> params) {
        FormBody.Builder formBuilder = new FormBody.Builder();
        if (params != null) {
            for (String key : params.keySet()) {
                formBuilder.add(key, params.get(key));
            }
        }
        return new Request.Builder().url(url).addHeader("Content-Type", "application/json; charset=utf-8").post((RequestBody)formBuilder.build()).build();
    }

    public String post(String url, String json) throws IOException {
        RequestBody body = RequestBody.create((MediaType)JSON, (String)json);
        Request request = new Request.Builder().url(url).post(body).build();
        return this.client.newCall(request).execute().body().string();
    }

    public <T> T post(String url, String json, Class<T> classOfT) throws IOException {
        RequestBody body = RequestBody.create((MediaType)JSON, (String)json);
        Request request = new Request.Builder().url(url).post(body).build();
        Response response = this.client.newCall(request).execute();
        assert (response.body() != null);
        String result = response.body().string();
        return (T)GOSN.fromJson(result, classOfT);
    }

    public String post(String url, Map<String, String> params) throws IOException {
        String json = GOSN.toJson(params);
        RequestBody body = RequestBody.create((MediaType)JSON, (String)json);
        Request request = new Request.Builder().url(url).post(body).build();
        return this.client.newCall(request).execute().body().string();
    }

    public Gson getGosn() {
        return GOSN;
    }
}

