/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.dromara.soul.client.core.disruptor.executor;

import com.google.common.collect.Lists;
import org.dromara.soul.disruptor.consumer.QueueConsumerExecutor;
import org.dromara.soul.disruptor.consumer.QueueConsumerFactory;
import org.dromara.soul.register.common.subsriber.ExecutorSubscriber;
import org.dromara.soul.register.common.type.DataTypeParent;

/**
 * The type Consumer executor.
 *
 * @author xiaoyu
 */
@SuppressWarnings("all")
public class RegisterClientConsumerExecutor extends QueueConsumerExecutor<DataTypeParent> {
    
    private ExecutorSubscriber executorSubscriber;
    
    public RegisterClientConsumerExecutor(final ExecutorSubscriber executorSubscriber) {
        this.executorSubscriber = executorSubscriber;
    }

    @Override
    public void run() {
        DataTypeParent result = getData();
        executorSubscriber.executor(Lists.newArrayList(result));
    }
    
    public static class RegisterClientExecutorFactory implements QueueConsumerFactory {
        
        private ExecutorSubscriber executorSubscriber;
        
        public RegisterClientExecutorFactory(final ExecutorSubscriber executorSubscriber) {
            this.executorSubscriber = executorSubscriber;
        }

        @Override
        public QueueConsumerExecutor create() {
            return new RegisterClientConsumerExecutor(executorSubscriber);
        }

        @Override
        public String fixName() {
            return "soul_register_client";
        }
    }
}
