/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.soul.client.springcloud.spring;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import org.dromara.soul.client.common.annotation.SoulClient;
import org.dromara.soul.client.common.dto.MetaDataDTO;
import org.dromara.soul.client.common.utils.OkHttpTools;
import org.dromara.soul.client.springcloud.config.SoulSpringCloudConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.env.Environment;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Controller;
import org.springframework.util.ReflectionUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

public class SoulSpringCloudClientBeanPostProcessor
implements BeanPostProcessor {
    private static final Logger log = LoggerFactory.getLogger(SoulSpringCloudClientBeanPostProcessor.class);
    private ExecutorService executorService = Executors.newSingleThreadExecutor();
    private final Environment env;
    private SoulSpringCloudConfig soulSpringCloudConfig;
    private final String url;

    public SoulSpringCloudClientBeanPostProcessor(Environment env, SoulSpringCloudConfig soulSpringCloudConfig) {
        this.env = env;
        this.soulSpringCloudConfig = soulSpringCloudConfig;
        this.url = soulSpringCloudConfig.getAdminUrl() + "/meta-data/register";
    }

    public Object postProcessBeforeInitialization(@NonNull Object bean, @NonNull String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(@NonNull Object bean, @NonNull String beanName) throws BeansException {
        Controller controller = (Controller)AnnotationUtils.findAnnotation(bean.getClass(), Controller.class);
        RestController restController = (RestController)AnnotationUtils.findAnnotation(bean.getClass(), RestController.class);
        RequestMapping requestMapping = (RequestMapping)AnnotationUtils.findAnnotation(bean.getClass(), RequestMapping.class);
        if (controller != null || restController != null || requestMapping != null) {
            Method[] methods;
            String contextPath = this.soulSpringCloudConfig.getContextPath();
            String adminUrl = this.soulSpringCloudConfig.getAdminUrl();
            if (contextPath == null || "".equals(contextPath) || adminUrl == null || "".equals(adminUrl)) {
                log.error("springCloud client must config context-path error");
                return bean;
            }
            for (Method method : methods = ReflectionUtils.getUniqueDeclaredMethods(bean.getClass())) {
                SoulClient soulClient = (SoulClient)AnnotationUtils.findAnnotation((Method)method, SoulClient.class);
                if (!Objects.nonNull(soulClient)) continue;
                this.executorService.execute(() -> this.post(this.buildJsonParams(soulClient, contextPath, bean, method)));
            }
        }
        return bean;
    }

    private void post(String json) {
        try {
            String result = OkHttpTools.getInstance().post(this.url, json);
            if (Objects.equals(result, "success")) {
                log.info("springCloud client register success :{} " + json);
            } else {
                log.error("springCloud client register error :{} " + json);
            }
        }
        catch (IOException e) {
            log.error("cannot register soul admin param :{}", (Object)(this.url + ":" + json));
        }
    }

    private String buildJsonParams(SoulClient soulClient, String contextPath, Object bean, Method method) {
        String appName = this.soulSpringCloudConfig.getAppName();
        if (appName == null || "".equals(appName)) {
            appName = this.env.getProperty("spring.application.name");
        }
        String path = contextPath + soulClient.path();
        String desc = soulClient.desc();
        String serviceName = bean.getClass().getSimpleName();
        String methodName = method.getName();
        Class<?>[] parameterTypesClazz = method.getParameterTypes();
        String parameterTypes = Arrays.stream(parameterTypesClazz).map(Class::getName).collect(Collectors.joining(","));
        MetaDataDTO metaDataDTO = MetaDataDTO.builder().appName(appName).serviceName(serviceName).methodName(methodName).path(path).pathDesc(desc).parameterTypes(parameterTypes).rpcExt("").rpcType("springCloud").enabled(soulClient.enabled()).build();
        return OkHttpTools.getInstance().getGosn().toJson((Object)metaDataDTO);
    }
}

