/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.soul.configuration.zookeeper.serializer;

import com.caucho.hessian.io.Hessian2Input;
import com.caucho.hessian.io.Hessian2Output;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.I0Itec.zkclient.exception.ZkMarshallingError;
import org.I0Itec.zkclient.serialize.ZkSerializer;
import org.dromara.soul.common.enums.SerializeEnum;
import org.dromara.soul.common.exception.SerializerException;
import org.dromara.soul.configuration.zookeeper.SerializerName;

public class HessianSerializer
implements ZkSerializer,
SerializerName {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] serialize(Object obj) {
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            Hessian2Output hos = new Hessian2Output((OutputStream)bos);
            hos.writeObject(obj);
            hos.flush();
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
        catch (IOException ex) {
            throw new SerializerException("Hessian serialize error " + ex.getMessage());
        }
    }

    public Object deserialize(byte[] bytes) throws ZkMarshallingError {
        try {
            ByteArrayInputStream bios = new ByteArrayInputStream(bytes);
            Hessian2Input his = new Hessian2Input((InputStream)bios);
            return his.readObject();
        }
        catch (IOException e) {
            throw new SerializerException("Hessian deSerialize error " + e.getMessage());
        }
    }

    @Override
    public String named() {
        return SerializeEnum.HESSIAN.getSerialize();
    }
}

