/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.soul.configuration.zookeeper.serializer;

import com.dyuproject.protostuff.LinkedBuffer;
import com.dyuproject.protostuff.ProtostuffIOUtil;
import com.dyuproject.protostuff.Schema;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.I0Itec.zkclient.exception.ZkMarshallingError;
import org.I0Itec.zkclient.serialize.ZkSerializer;
import org.dromara.soul.common.enums.SerializeEnum;
import org.dromara.soul.common.exception.SerializerException;
import org.dromara.soul.configuration.zookeeper.SerializerName;
import org.dromara.soul.configuration.zookeeper.serializer.SchemaCache;
import org.objenesis.Objenesis;
import org.objenesis.ObjenesisStd;

public class ProtostuffSerializer
implements ZkSerializer,
SerializerName {
    private static final SchemaCache CACHED_SCHEMA = SchemaCache.getInstance();
    private static final Objenesis OBJENESIS = new ObjenesisStd(true);

    private static <T> Schema<T> getSchema(Class<T> cls) {
        return CACHED_SCHEMA.get(cls);
    }

    public byte[] serialize(Object obj) {
        Class<?> cls = obj.getClass();
        LinkedBuffer buffer = LinkedBuffer.allocate((int)512);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            Schema<?> schema = ProtostuffSerializer.getSchema(cls);
            ProtostuffIOUtil.writeTo((OutputStream)outputStream, (Object)obj, schema, (LinkedBuffer)buffer);
        }
        catch (IOException e) {
            throw new SerializerException(e.getMessage(), (Throwable)e);
        }
        finally {
            buffer.clear();
        }
        return outputStream.toByteArray();
    }

    public Object deserialize(byte[] bytes) throws ZkMarshallingError {
        try {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
            Class<Object> cls = Object.class;
            Object object = OBJENESIS.newInstance(Object.class);
            Schema<Object> schema = ProtostuffSerializer.getSchema(cls);
            ProtostuffIOUtil.mergeFrom((InputStream)inputStream, (Object)object, schema);
            return object;
        }
        catch (IOException e) {
            throw new SerializerException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public String named() {
        return SerializeEnum.PROTOSTUFF.getSerialize();
    }
}

