/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.soul.configuration.zookeeper;

import org.I0Itec.zkclient.ZkClient;
import org.I0Itec.zkclient.serialize.ZkSerializer;
import org.dromara.soul.configuration.zookeeper.ZookeeperConfig;
import org.dromara.soul.configuration.zookeeper.serializer.ZkSerializerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.SearchStrategy;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class ZookeeperConfiguration {
    @Bean
    @ConfigurationProperties(prefix="spring.zookeeper")
    public ZookeeperConfig zookeeperConfig() {
        return new ZookeeperConfig();
    }

    @Bean
    @ConditionalOnMissingBean(value={ZkSerializer.class}, search=SearchStrategy.ALL)
    public ZkSerializer zkSerializer(ZookeeperConfig zookeeperConfig) {
        return ZkSerializerFactory.of(zookeeperConfig.getSerializer());
    }

    @Bean
    public ZkClient zkClient(ZookeeperConfig zookeeperConfig, ZkSerializer zkSerializer) {
        return new ZkClient(zookeeperConfig.getUrl(), zookeeperConfig.getSessionTimeout().intValue(), zookeeperConfig.getConnectionTimeout().intValue(), zkSerializer);
    }
}

