/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.soul.configuration.zookeeper.serializer;

import org.I0Itec.zkclient.serialize.ZkSerializer;
import org.dromara.soul.common.enums.SerializeEnum;
import org.dromara.soul.configuration.zookeeper.serializer.FastJsonSerializer;
import org.dromara.soul.configuration.zookeeper.serializer.HessianSerializer;
import org.dromara.soul.configuration.zookeeper.serializer.JavaSerializer;
import org.dromara.soul.configuration.zookeeper.serializer.KryoSerializer;
import org.dromara.soul.configuration.zookeeper.serializer.ProtostuffSerializer;

public class ZkSerializerFactory {
    public static ZkSerializer of(String name) {
        SerializeEnum serializeEnum = SerializeEnum.acquire((String)name);
        switch (serializeEnum) {
            case KRYO: {
                return new KryoSerializer();
            }
            case JDK: {
                return new JavaSerializer();
            }
            case HESSIAN: {
                return new HessianSerializer();
            }
            case PROTOSTUFF: {
                return new ProtostuffSerializer();
            }
            case FAST_JSON: {
                return new FastJsonSerializer();
            }
        }
        return new JavaSerializer();
    }
}

