/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.soul.configuration.zookeeper.serializer;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.I0Itec.zkclient.exception.ZkMarshallingError;
import org.I0Itec.zkclient.serialize.ZkSerializer;
import org.dromara.soul.common.exception.SerializerException;

public class KryoSerializer
implements ZkSerializer {
    public byte[] serialize(Object obj) {
        byte[] bytes;
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            Kryo kryo = new Kryo();
            Output output = new Output((OutputStream)outputStream);
            kryo.writeClassAndObject(output, obj);
            bytes = output.toBytes();
            output.flush();
        }
        catch (IOException ex) {
            throw new SerializerException("kryo serialize error" + ex.getMessage());
        }
        return bytes;
    }

    public Object deserialize(byte[] bytes) throws ZkMarshallingError {
        Object object;
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);){
            Kryo kryo = new Kryo();
            Input input = new Input((InputStream)inputStream);
            object = kryo.readClassAndObject(input);
            input.close();
        }
        catch (IOException e) {
            throw new SerializerException("kryo deSerialize error" + e.getMessage());
        }
        return object;
    }
}

