/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.soul.metrics.facade;

import com.google.common.base.Preconditions;
import java.util.Optional;
import org.dromara.soul.metrics.api.HistogramMetricsTrackerDelegate;
import org.dromara.soul.metrics.api.SummaryMetricsTrackerDelegate;
import org.dromara.soul.metrics.config.MetricsConfig;
import org.dromara.soul.metrics.facade.handler.MetricsTrackerHandler;
import org.dromara.soul.metrics.spi.MetricsTrackerManager;
import org.dromara.soul.spi.ExtensionLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MetricsTrackerFacade {
    private static final Logger log = LoggerFactory.getLogger(MetricsTrackerFacade.class);
    private MetricsTrackerManager metricsTrackerManager;
    private volatile boolean enabled;

    private MetricsTrackerFacade() {
        this.loadMetricsManager();
    }

    public static MetricsTrackerFacade getInstance() {
        return MetricsTrackerFacadeHolder.INSTANCE;
    }

    public void start(MetricsConfig metricsConfig) {
        this.metricsTrackerManager = (MetricsTrackerManager)ExtensionLoader.getExtensionLoader(MetricsTrackerManager.class).getJoin(metricsConfig.getMetricsName());
        Preconditions.checkNotNull((Object)this.metricsTrackerManager, (Object)"Can not find metrics tracker manager with metrics name in metrics configuration.");
        this.metricsTrackerManager.start(metricsConfig);
        Integer threadCount = Optional.ofNullable(metricsConfig.getThreadCount()).orElse(Runtime.getRuntime().availableProcessors());
        MetricsTrackerHandler.getInstance().init(metricsConfig.getAsync(), threadCount, this.metricsTrackerManager);
        this.enabled = true;
    }

    public void counterInc(String metricsLabel, String ... labelValues) {
        if (this.enabled) {
            MetricsTrackerHandler.getInstance().counterInc(metricsLabel, labelValues);
        }
    }

    public void gaugeInc(String metricsLabel, String ... labelValues) {
        if (this.enabled) {
            MetricsTrackerHandler.getInstance().gaugeInc(metricsLabel, labelValues);
        }
    }

    public void gaugeDec(String metricsLabel, String ... labelValues) {
        if (this.enabled) {
            MetricsTrackerHandler.getInstance().gaugeDec(metricsLabel, labelValues);
        }
    }

    public Optional<HistogramMetricsTrackerDelegate> histogramStartTimer(String metricsLabel, String ... labelValues) {
        if (!this.enabled) {
            return Optional.empty();
        }
        return MetricsTrackerHandler.getInstance().histogramStartTimer(metricsLabel, labelValues);
    }

    public void histogramObserveDuration(HistogramMetricsTrackerDelegate delegate) {
        if (this.enabled) {
            MetricsTrackerHandler.getInstance().histogramObserveDuration(delegate);
        }
    }

    public Optional<SummaryMetricsTrackerDelegate> summaryStartTimer(String metricsLabel, String ... labelValues) {
        if (!this.enabled) {
            return Optional.empty();
        }
        return MetricsTrackerHandler.getInstance().summaryStartTimer(metricsLabel, labelValues);
    }

    public void summaryObserveDuration(SummaryMetricsTrackerDelegate delegate) {
        if (this.enabled) {
            MetricsTrackerHandler.getInstance().summaryObserveDuration(delegate);
        }
    }

    public void stop() {
        this.enabled = false;
        if (null != this.metricsTrackerManager) {
            this.metricsTrackerManager.stop();
        }
        MetricsTrackerHandler.getInstance().close();
    }

    private void loadMetricsManager() {
    }

    public MetricsTrackerManager getMetricsTrackerManager() {
        return this.metricsTrackerManager;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    private static class MetricsTrackerFacadeHolder {
        private static final MetricsTrackerFacade INSTANCE = new MetricsTrackerFacade();

        private MetricsTrackerFacadeHolder() {
        }
    }
}

