/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.soul.metrics.facade.executor;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.dromara.soul.common.concurrent.SoulThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MetricsThreadPoolExecutor
extends ThreadPoolExecutor {
    private static final Logger log = LoggerFactory.getLogger(MetricsThreadPoolExecutor.class);
    private final String name;

    public MetricsThreadPoolExecutor(int threadCount, int queueSize) {
        super(threadCount, threadCount, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(queueSize), SoulThreadFactory.create((String)"metrics", (boolean)true), MetricsThreadPoolExecutor.buildRejectedExecutionHandler(queueSize));
        this.name = "metrics";
    }

    private static RejectedExecutionHandler buildRejectedExecutionHandler(int size) {
        return (r, executor) -> {
            BlockingQueue<Runnable> queue = executor.getQueue();
            while (queue.size() >= size) {
                if (executor.isShutdown()) {
                    throw new RejectedExecutionException("metrics thread pool executor closed");
                }
                ((MetricsThreadPoolExecutor)executor).onRejected();
            }
            if (!executor.isShutdown()) {
                executor.execute(r);
            }
        };
    }

    private void onRejected() {
        log.info("...thread:{}, Saturation occurs, actuator:{}", (Object)Thread.currentThread().getName(), (Object)this.name);
    }

    public String getName() {
        return this.name;
    }
}

