/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.soul.metrics.facade;

import com.google.common.base.Preconditions;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.dromara.soul.metrics.config.MetricsConfig;
import org.dromara.soul.metrics.spi.MetricsBootService;
import org.dromara.soul.spi.ExtensionLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MetricsTrackerFacade {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MetricsTrackerFacade.class);
    private MetricsBootService metricsBootService;
    private final AtomicBoolean isStarted = new AtomicBoolean(false);

    private MetricsTrackerFacade() {
    }

    public static MetricsTrackerFacade getInstance() {
        return MetricsTrackerFacadeHolder.INSTANCE;
    }

    public void start(MetricsConfig metricsConfig) {
        if (this.isStarted.compareAndSet(false, true)) {
            this.metricsBootService = (MetricsBootService)ExtensionLoader.getExtensionLoader(MetricsBootService.class).getJoin(metricsConfig.getMetricsName());
            Preconditions.checkNotNull((Object)this.metricsBootService, (String)"Can not find metrics tracker manager with metrics name : %s in metrics configuration.", (Object)metricsConfig.getMetricsName());
            this.metricsBootService.start(metricsConfig);
        } else {
            log.info("metrics tracker has started !");
        }
    }

    public void stop() {
        this.isStarted.compareAndSet(true, false);
        if (null != this.metricsBootService) {
            this.metricsBootService.stop();
        }
    }

    public boolean isStarted() {
        return this.isStarted.get();
    }

    private static class MetricsTrackerFacadeHolder {
        private static final MetricsTrackerFacade INSTANCE = new MetricsTrackerFacade();

        private MetricsTrackerFacadeHolder() {
        }
    }
}

