/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.soul.metrics.prometheus;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import org.dromara.soul.metrics.api.MetricsTracker;
import org.dromara.soul.metrics.api.MetricsTrackerFactory;
import org.dromara.soul.metrics.prometheus.impl.counter.HttpRequestCounterMetricsTracker;
import org.dromara.soul.metrics.prometheus.impl.counter.RequestTotalCounterMetricsTracker;
import org.dromara.soul.metrics.prometheus.impl.histogram.RequestLatencyHistogramMetricsTracker;
import org.dromara.soul.metrics.prometheus.impl.summary.RequestLatencySummaryMetricsTracker;

public final class PrometheusMetricsTrackerFactory
implements MetricsTrackerFactory {
    private static final Collection<MetricsTracker> REGISTER = new ArrayList<MetricsTracker>();

    public Optional<MetricsTracker> create(String metricsType, String metricsLabel) {
        return REGISTER.stream().filter(each -> each.metricsLabel().equals(metricsLabel) && each.metricsType().equals(metricsType)).findFirst();
    }

    static {
        REGISTER.add((MetricsTracker)new RequestTotalCounterMetricsTracker());
        REGISTER.add((MetricsTracker)new HttpRequestCounterMetricsTracker());
        REGISTER.add((MetricsTracker)new RequestLatencyHistogramMetricsTracker());
        REGISTER.add((MetricsTracker)new RequestLatencySummaryMetricsTracker());
    }
}

