/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.soul.metrics.prometheus;

import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.exporter.HTTPServer;
import io.prometheus.client.hotspot.DefaultExports;
import java.net.InetSocketAddress;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.management.MalformedObjectNameException;
import org.dromara.soul.metrics.api.MetricsTrackerFactory;
import org.dromara.soul.metrics.config.MetricsConfig;
import org.dromara.soul.metrics.prometheus.PrometheusMetricsTrackerFactory;
import org.dromara.soul.metrics.prometheus.impl.collector.BuildInfoCollector;
import org.dromara.soul.metrics.prometheus.impl.collector.JmxCollector;
import org.dromara.soul.metrics.spi.MetricsTrackerManager;
import org.dromara.soul.spi.Join;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Join
public final class PrometheusMetricsTrackerManager
implements MetricsTrackerManager {
    private static final Logger log = LoggerFactory.getLogger(PrometheusMetricsTrackerManager.class);
    private final MetricsTrackerFactory metricsTrackerFactory = new PrometheusMetricsTrackerFactory();
    private HTTPServer server;
    private volatile AtomicBoolean registered = new AtomicBoolean(false);

    public void start(MetricsConfig metricsConfig) {
        this.register(metricsConfig.getJmxConfig());
        InetSocketAddress inetSocketAddress = "".equals(metricsConfig.getHost()) || null == metricsConfig.getHost() ? new InetSocketAddress(metricsConfig.getPort()) : new InetSocketAddress(metricsConfig.getHost(), (int)metricsConfig.getPort());
        this.server = new HTTPServer(inetSocketAddress, CollectorRegistry.defaultRegistry, true);
        log.info("you start prometheus metrics http server  host is :{}, port is :{} ", (Object)inetSocketAddress.getHostString(), (Object)inetSocketAddress.getPort());
    }

    public void stop() {
        this.server.stop();
    }

    private void register(String jmxConfig) {
        if (!this.registered.compareAndSet(false, true)) {
            return;
        }
        new BuildInfoCollector().register();
        try {
            new JmxCollector(jmxConfig).register();
            DefaultExports.initialize();
        }
        catch (MalformedObjectNameException e) {
            log.error("init jxm collector error", (Throwable)e);
        }
    }

    public MetricsTrackerFactory getMetricsTrackerFactory() {
        return this.metricsTrackerFactory;
    }

    public HTTPServer getServer() {
        return this.server;
    }

    public AtomicBoolean getRegistered() {
        return this.registered;
    }
}

