/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.soul.metrics.prometheus.impl.collector;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.InstanceNotFoundException;
import javax.management.JMException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServerConnection;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularType;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import javax.rmi.ssl.SslRMIClientSocketFactory;
import org.dromara.soul.metrics.prometheus.impl.collector.JmxMBeanPropertyCache;
import org.dromara.soul.metrics.prometheus.impl.collector.MBeanReceiver;

public class JmxScraper {
    private static final Logger LOGGER = Logger.getLogger(JmxScraper.class.getName());
    private final MBeanReceiver receiver;
    private final String jmxUrl;
    private final String username;
    private final String password;
    private final boolean ssl;
    private final List<ObjectName> whitelistObjectNames;
    private final List<ObjectName> blacklistObjectNames;
    private final JmxMBeanPropertyCache jmxMBeanPropertyCache;

    public JmxScraper(String jmxUrl, String username, String password, boolean ssl, List<ObjectName> whitelistObjectNames, List<ObjectName> blacklistObjectNames, MBeanReceiver receiver, JmxMBeanPropertyCache jmxMBeanPropertyCache) {
        this.jmxUrl = jmxUrl;
        this.receiver = receiver;
        this.username = username;
        this.password = password;
        this.ssl = ssl;
        this.whitelistObjectNames = whitelistObjectNames;
        this.blacklistObjectNames = blacklistObjectNames;
        this.jmxMBeanPropertyCache = jmxMBeanPropertyCache;
    }

    private static void logScrape(ObjectName mbeanName, Set<String> names, String msg) {
        JmxScraper.logScrape(mbeanName + "_" + names, msg);
    }

    private static void logScrape(ObjectName mbeanName, MBeanAttributeInfo attr, String msg) {
        JmxScraper.logScrape(mbeanName + "'_'" + attr.getName(), msg);
    }

    private static void logScrape(String name, String msg) {
        LOGGER.log(Level.FINE, "scrape: '" + name + "': " + msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doScrape() throws IOException {
        MBeanServerConnection beanConn;
        JMXConnector jmxc = null;
        if (this.jmxUrl.isEmpty()) {
            beanConn = ManagementFactory.getPlatformMBeanServer();
        } else {
            HashMap<String, Object> environment = new HashMap<String, Object>();
            if (this.username != null && this.username.length() != 0 && this.password != null && this.password.length() != 0) {
                String[] credent = new String[]{this.username, this.password};
                environment.put("jmx.remote.credentials", credent);
            }
            if (this.ssl) {
                environment.put("java.naming.security.protocol", "ssl");
                SslRMIClientSocketFactory clientSocketFactory = new SslRMIClientSocketFactory();
                environment.put("jmx.remote.rmi.client.socket.factory", clientSocketFactory);
                environment.put("com.sun.jndi.rmi.factory.socket", clientSocketFactory);
            }
            jmxc = JMXConnectorFactory.connect(new JMXServiceURL(this.jmxUrl), environment);
            beanConn = jmxc.getMBeanServerConnection();
        }
        try {
            HashSet<ObjectName> mBeanNames = new HashSet<ObjectName>();
            for (ObjectName name : this.whitelistObjectNames) {
                for (ObjectInstance instance : beanConn.queryMBeans(name, null)) {
                    mBeanNames.add(instance.getObjectName());
                }
            }
            for (ObjectName name : this.blacklistObjectNames) {
                for (ObjectInstance instance : beanConn.queryMBeans(name, null)) {
                    mBeanNames.remove(instance.getObjectName());
                }
            }
            this.jmxMBeanPropertyCache.onlyKeepMBeans(mBeanNames);
            for (ObjectName objectName : mBeanNames) {
                long start = System.nanoTime();
                this.scrapeBean(beanConn, objectName);
                LOGGER.fine("TIME: " + (System.nanoTime() - start) + " ns for " + objectName.toString());
            }
        }
        finally {
            if (jmxc != null) {
                jmxc.close();
            }
        }
    }

    private void scrapeBean(MBeanServerConnection beanConn, ObjectName mbeanName) {
        AttributeList attributes;
        MBeanInfo info;
        try {
            info = beanConn.getMBeanInfo(mbeanName);
        }
        catch (IOException | JMException e) {
            JmxScraper.logScrape(mbeanName.toString(), "getMBeanInfo Fail: " + e);
            return;
        }
        MBeanAttributeInfo[] attrInfos = info.getAttributes();
        LinkedHashMap<String, MBeanAttributeInfo> name2AttrInfo = new LinkedHashMap<String, MBeanAttributeInfo>();
        for (MBeanAttributeInfo attr : attrInfos) {
            if (!attr.isReadable()) {
                JmxScraper.logScrape(mbeanName, attr, "not readable");
                continue;
            }
            name2AttrInfo.put(attr.getName(), attr);
        }
        try {
            attributes = beanConn.getAttributes(mbeanName, name2AttrInfo.keySet().toArray(new String[0]));
            if (attributes == null) {
                JmxScraper.logScrape(mbeanName.toString(), "getAttributes Fail: attributes are null");
                return;
            }
        }
        catch (IOException | InstanceNotFoundException | ReflectionException e) {
            JmxScraper.logScrape(mbeanName, name2AttrInfo.keySet(), "Fail: " + e);
            return;
        }
        for (Attribute attribute : attributes.asList()) {
            MBeanAttributeInfo attr;
            attr = (MBeanAttributeInfo)name2AttrInfo.get(attribute.getName());
            JmxScraper.logScrape(mbeanName, attr, "process");
            this.processBeanValue(mbeanName.getDomain(), this.jmxMBeanPropertyCache.getKeyPropertyList(mbeanName), new LinkedList<String>(), attr.getName(), attr.getType(), attr.getDescription(), attribute.getValue());
        }
    }

    private void processBeanValue(String domain, Map<String, String> beanProperties, LinkedList<String> attrKeysParam, String attrName, String attrTypeParam, String attrDescription, Object valueParam) {
        LinkedList<String> attrKeys = attrKeysParam;
        String attrType = attrTypeParam;
        Object value = valueParam;
        if (value == null) {
            JmxScraper.logScrape(domain + beanProperties + attrName, "null");
        } else if (value instanceof Number || value instanceof String || value instanceof Boolean || value instanceof Date) {
            if (value instanceof Date) {
                attrType = "java.lang.Double";
                value = (double)((Date)value).getTime() / 1000.0;
            }
            JmxScraper.logScrape(domain + beanProperties + attrName, value.toString());
            this.receiver.recordBean(domain, beanProperties, attrKeys, attrName, attrType, attrDescription, value);
        } else if (value instanceof CompositeData) {
            JmxScraper.logScrape(domain + beanProperties + attrName, "compositedata");
            CompositeData composite = (CompositeData)value;
            CompositeType type = composite.getCompositeType();
            attrKeys = new LinkedList<String>(attrKeys);
            attrKeys.add(attrName);
            for (String key : type.keySet()) {
                String typ = type.getType(key).getTypeName();
                Object valu = composite.get(key);
                this.processBeanValue(domain, beanProperties, attrKeys, key, typ, type.getDescription(), valu);
            }
        } else if (value instanceof TabularData) {
            JmxScraper.logScrape(domain + beanProperties + attrName, "tabulardata");
            TabularData tds = (TabularData)value;
            TabularType tt = tds.getTabularType();
            List<String> rowKeys = tt.getIndexNames();
            CompositeType type = tt.getRowType();
            TreeSet<String> valueKeys = new TreeSet<String>(type.keySet());
            valueKeys.removeAll(rowKeys);
            LinkedList<String> extendedAttrKeys = new LinkedList<String>(attrKeys);
            extendedAttrKeys.add(attrName);
            for (Object valu : tds.values()) {
                if (valu instanceof CompositeData) {
                    CompositeData composite = (CompositeData)valu;
                    LinkedHashMap<String, String> rowKeyMap = new LinkedHashMap<String, String>(beanProperties);
                    for (String rowKey : rowKeys) {
                        String resultKey = rowKey;
                        Object obj = composite.get(resultKey);
                        if (obj == null) continue;
                        while (rowKeyMap.containsKey(resultKey)) {
                            resultKey = resultKey + "_";
                        }
                        rowKeyMap.put(resultKey, obj.toString());
                    }
                    for (String valueIdx : valueKeys) {
                        LinkedList<String> attrNames = extendedAttrKeys;
                        String typ = type.getType(valueIdx).getTypeName();
                        String name = valueIdx;
                        if ("value".equalsIgnoreCase(valueIdx.toLowerCase())) {
                            attrNames = attrKeys;
                            name = attrName;
                        }
                        this.processBeanValue(domain, rowKeyMap, attrNames, name, typ, type.getDescription(), composite.get(valueIdx));
                    }
                    continue;
                }
                JmxScraper.logScrape(domain, "not a correct tabulardata format");
            }
        } else if (value.getClass().isArray()) {
            JmxScraper.logScrape(domain, "arrays are unsupported");
        } else {
            JmxScraper.logScrape(domain + beanProperties, attrType + " is not exported");
        }
    }
}

