/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.soul.metrics.prometheus.collector;

import io.prometheus.client.Collector;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.dromara.soul.common.utils.GsonUtils;
import org.dromara.soul.metrics.config.JmxConfig;
import org.dromara.soul.metrics.prometheus.collector.JmxMBeanPropertyCache;
import org.dromara.soul.metrics.prometheus.collector.JmxScraper;
import org.dromara.soul.metrics.prometheus.collector.MBeanReceiver;

public class JmxCollector
extends Collector
implements Collector.Describable {
    private static final Logger LOGGER = Logger.getLogger(JmxCollector.class.getName());
    private final JmxConfig config;
    private final long createTimeNanoSecs = System.nanoTime();
    private final JmxMBeanPropertyCache jmxMBeanPropertyCache = new JmxMBeanPropertyCache();

    public JmxCollector(String json) throws MalformedObjectNameException {
        this.config = this.loadConfig(GsonUtils.getInstance().toObjectMap(json));
    }

    private JmxConfig loadConfig(Map<String, Object> paramMap) throws MalformedObjectNameException {
        List names;
        JmxConfig cfg = new JmxConfig();
        if (paramMap == null || paramMap.size() == 0) {
            return cfg;
        }
        if (paramMap.containsKey("startDelaySeconds")) {
            try {
                cfg.setStartDelaySeconds(Integer.valueOf(paramMap.get("startDelaySeconds").toString()));
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Invalid number provided for startDelaySeconds", e);
            }
        }
        if (paramMap.containsKey("hostPort")) {
            if (paramMap.containsKey("jmxUrl")) {
                throw new IllegalArgumentException("At most one of hostPort and jmxUrl must be provided");
            }
            cfg.setJmxUrl("service:jmx:rmi:///jndi/rmi://" + paramMap.get("hostPort") + "/jmxrmi");
        } else if (paramMap.containsKey("jmxUrl")) {
            cfg.setJmxUrl((String)paramMap.get("jmxUrl"));
        }
        if (paramMap.containsKey("username")) {
            cfg.setUsername((String)paramMap.get("username"));
        }
        if (paramMap.containsKey("password")) {
            cfg.setPassword((String)paramMap.get("password"));
        }
        if (paramMap.containsKey("ssl")) {
            cfg.setSsl(((Boolean)paramMap.get("ssl")).booleanValue());
        }
        if (paramMap.containsKey("lowercaseOutputName")) {
            cfg.setLowercaseOutputName(((Boolean)paramMap.get("lowercaseOutputName")).booleanValue());
        }
        if (paramMap.containsKey("lowercaseOutputLabelNames")) {
            cfg.setLowercaseOutputLabelNames(((Boolean)paramMap.get("lowercaseOutputLabelNames")).booleanValue());
        }
        if (paramMap.containsKey("whitelistObjectNames")) {
            names = GsonUtils.getInstance().fromList(paramMap.get("whitelistObjectNames").toString(), String.class);
            for (String name : names) {
                cfg.getWhitelistObjectNames().add(new ObjectName(name));
            }
        }
        if (paramMap.containsKey("blacklistObjectNames")) {
            names = GsonUtils.getInstance().fromList(paramMap.get("blacklistObjectNames").toString(), String.class);
            for (String name : names) {
                cfg.getBlacklistObjectNames().add(new ObjectName(name));
            }
        }
        if (paramMap.containsKey("rules")) {
            List configRules = GsonUtils.getInstance().toListMap(paramMap.get("rules").toString());
            for (Map ruleObject : configRules) {
                JmxConfig.Rule rule = new JmxConfig.Rule();
                cfg.getRules().add(rule);
                if (ruleObject.containsKey("pattern")) {
                    rule.setPattern(Pattern.compile("^.*(?:" + ruleObject.get("pattern") + ").*$"));
                }
                if (ruleObject.containsKey("name")) {
                    rule.setName((String)ruleObject.get("name"));
                }
                if (ruleObject.containsKey("value")) {
                    rule.setValue(String.valueOf(ruleObject.get("value")));
                }
                if (ruleObject.containsKey("valueFactor")) {
                    String valueFactor = String.valueOf(ruleObject.get("valueFactor"));
                    try {
                        rule.setValueFactor(Double.valueOf(valueFactor));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (ruleObject.containsKey("attrNameSnakeCase")) {
                    rule.setAttrNameSnakeCase(((Boolean)ruleObject.get("attrNameSnakeCase")).booleanValue());
                }
                if (ruleObject.containsKey("type")) {
                    rule.setType(JmxConfig.Type.valueOf((String)String.valueOf(ruleObject.get("type"))));
                }
                if (ruleObject.containsKey("help")) {
                    rule.setHelp(String.valueOf(ruleObject.get("help")));
                }
                if (ruleObject.containsKey("labels")) {
                    ConcurrentNavigableMap labels = GsonUtils.getInstance().toTreeMap(ruleObject.get("labels").toString());
                    for (Map.Entry entry : labels.entrySet()) {
                        rule.getLabelNames().add(entry.getKey());
                        rule.getLabelValues().add((String)entry.getValue());
                    }
                }
                if ((rule.getLabelValues() != null || rule.getHelp() != null) && rule.getName() == null) {
                    throw new IllegalArgumentException("Must provide name, if help or labels are given: " + ruleObject);
                }
                if (rule.getName() == null || rule.getPattern() != null) continue;
                throw new IllegalArgumentException("Must provide pattern, if name is given: " + ruleObject);
            }
        } else {
            cfg.getRules().add(new JmxConfig.Rule());
        }
        return cfg;
    }

    private static String toSnakeAndLowerCase(String attrName) {
        if (attrName == null || attrName.isEmpty()) {
            return attrName;
        }
        char firstChar = attrName.subSequence(0, 1).charAt(0);
        boolean prevCharIsUpperCaseOrUnderscore = Character.isUpperCase(firstChar) || firstChar == '_';
        StringBuilder resultBuilder = new StringBuilder(attrName.length()).append(Character.toLowerCase(firstChar));
        for (char attrChar : attrName.substring(1).toCharArray()) {
            boolean charIsUpperCase = Character.isUpperCase(attrChar);
            if (!prevCharIsUpperCaseOrUnderscore && charIsUpperCase) {
                resultBuilder.append("_");
            }
            resultBuilder.append(Character.toLowerCase(attrChar));
            prevCharIsUpperCaseOrUnderscore = charIsUpperCase || attrChar == '_';
        }
        return resultBuilder.toString();
    }

    private static String safeName(String name) {
        if (name == null) {
            return null;
        }
        boolean prevCharIsUnderscore = false;
        StringBuilder safeNameBuilder = new StringBuilder(name.length());
        if (!name.isEmpty() && Character.isDigit(name.charAt(0))) {
            safeNameBuilder.append("_");
        }
        for (char nameChar : name.toCharArray()) {
            boolean isUnsafeChar;
            boolean bl = isUnsafeChar = !JmxCollector.isLegalCharacter(nameChar);
            if (isUnsafeChar || nameChar == '_') {
                if (prevCharIsUnderscore) continue;
                safeNameBuilder.append("_");
                prevCharIsUnderscore = true;
                continue;
            }
            safeNameBuilder.append(nameChar);
            prevCharIsUnderscore = false;
        }
        return safeNameBuilder.toString();
    }

    private static boolean isLegalCharacter(char input) {
        return input == ':' || input == '_' || input >= 'a' && input <= 'z' || input >= 'A' && input <= 'Z' || input >= '0' && input <= '9';
    }

    public List<Collector.MetricFamilySamples> collect() {
        Receiver receiver = new Receiver();
        JmxScraper scraper = new JmxScraper(this.config.getJmxUrl(), this.config.getUsername(), this.config.getPassword(), this.config.isSsl(), this.config.getWhitelistObjectNames(), this.config.getBlacklistObjectNames(), receiver, this.jmxMBeanPropertyCache);
        long start = System.nanoTime();
        double error = 0.0;
        if (this.config.getStartDelaySeconds() > 0 && (start - this.createTimeNanoSecs) / 1000000000L < (long)this.config.getStartDelaySeconds().intValue()) {
            throw new IllegalStateException("JMXCollector waiting for startDelaySeconds");
        }
        try {
            scraper.doScrape();
        }
        catch (IOException e) {
            error = 1.0;
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            LOGGER.severe("JMX scrape failed: " + sw.toString());
        }
        ArrayList<Collector.MetricFamilySamples> mfsList = new ArrayList<Collector.MetricFamilySamples>(receiver.metricFamilySamplesMap.values());
        ArrayList<Collector.MetricFamilySamples.Sample> samples = new ArrayList<Collector.MetricFamilySamples.Sample>();
        samples.add(new Collector.MetricFamilySamples.Sample("jmx_scrape_duration_seconds", new ArrayList(), new ArrayList(), (double)(System.nanoTime() - start) / 1.0E9));
        mfsList.add(new Collector.MetricFamilySamples("jmx_scrape_duration_seconds", Collector.Type.GAUGE, "Time this JMX scrape took, in seconds.", samples));
        samples = new ArrayList();
        samples.add(new Collector.MetricFamilySamples.Sample("jmx_scrape_error", new ArrayList(), new ArrayList(), error));
        mfsList.add(new Collector.MetricFamilySamples("jmx_scrape_error", Collector.Type.GAUGE, "Non-zero if this scrape failed.", samples));
        return mfsList;
    }

    public List<Collector.MetricFamilySamples> describe() {
        ArrayList<Collector.MetricFamilySamples> sampleFamilies = new ArrayList<Collector.MetricFamilySamples>();
        sampleFamilies.add(new Collector.MetricFamilySamples("jmx_scrape_duration_seconds", Collector.Type.GAUGE, "Time this JMX scrape took, in seconds.", new ArrayList()));
        sampleFamilies.add(new Collector.MetricFamilySamples("jmx_scrape_error", Collector.Type.GAUGE, "Non-zero if this scrape failed.", new ArrayList()));
        return sampleFamilies;
    }

    class Receiver
    implements MBeanReceiver {
        private static final char SEP = '_';
        private final Map<String, Collector.MetricFamilySamples> metricFamilySamplesMap = new HashMap<String, Collector.MetricFamilySamples>();

        Receiver() {
        }

        private String angleBrackets(String s) {
            return "<" + s.substring(1, s.length() - 1) + ">";
        }

        void addSample(Collector.MetricFamilySamples.Sample sample, Collector.Type type, String help) {
            Collector.MetricFamilySamples mfs = this.metricFamilySamplesMap.get(sample.name);
            if (mfs == null) {
                mfs = new Collector.MetricFamilySamples(sample.name, type, help, new ArrayList());
                this.metricFamilySamplesMap.put(sample.name, mfs);
            }
            mfs.samples.add(sample);
        }

        private void defaultExport(String domain, Map<String, String> beanProperties, LinkedList<String> attrKeys, String attrName, String help, Object value, Collector.Type type) {
            StringBuilder name = new StringBuilder();
            name.append(domain);
            if (beanProperties.size() > 0) {
                name.append('_');
                name.append(beanProperties.values().iterator().next());
            }
            for (String k : attrKeys) {
                name.append('_');
                name.append(k);
            }
            name.append('_');
            name.append(attrName);
            String fullname = JmxCollector.safeName(name.toString());
            if (JmxCollector.this.config.isLowercaseOutputName()) {
                fullname = fullname.toLowerCase();
            }
            ArrayList<String> labelNames = new ArrayList<String>();
            ArrayList<String> labelValues = new ArrayList<String>();
            if (beanProperties.size() > 1) {
                Iterator<Map.Entry<String, String>> iter = beanProperties.entrySet().iterator();
                iter.next();
                while (iter.hasNext()) {
                    Map.Entry<String, String> entry = iter.next();
                    String labelName = JmxCollector.safeName(entry.getKey());
                    if (JmxCollector.this.config.isLowercaseOutputName()) {
                        labelName = labelName.toLowerCase();
                    }
                    labelNames.add(labelName);
                    labelValues.add(entry.getValue());
                }
            }
            this.addSample(new Collector.MetricFamilySamples.Sample(fullname, labelNames, labelValues, ((Number)value).doubleValue()), type, help);
        }

        @Override
        public void recordBean(String domain, Map<String, String> beanProperties, LinkedList<String> attrKeys, String attrName, String attrType, String attrDescription, Object beanObject) {
            String beanName = domain + this.angleBrackets(beanProperties.toString()) + this.angleBrackets(attrKeys.toString());
            String help = attrDescription + " (" + beanName + attrName + ")";
            String attrNameSnakeCase = JmxCollector.toSnakeAndLowerCase(attrName);
            for (JmxConfig.Rule rule : JmxCollector.this.config.getRules()) {
                Number value;
                Matcher matcher = null;
                String matchName = beanName + (rule.isAttrNameSnakeCase() ? attrNameSnakeCase : attrName);
                if (rule.getPattern() != null && !(matcher = rule.getPattern().matcher(matchName + ": " + beanObject)).matches()) continue;
                Object beanValue = beanObject;
                if (rule.getValue() != null && !rule.getValue().isEmpty()) {
                    assert (matcher != null);
                    String val = matcher.replaceAll(rule.getValue());
                    try {
                        beanValue = Double.valueOf(val);
                    }
                    catch (NumberFormatException e) {
                        LOGGER.fine("Unable to parse configured value '" + val + "' to number for bean: " + beanName + attrName + ": " + beanValue);
                        return;
                    }
                }
                if (beanValue instanceof Number) {
                    value = ((Number)beanValue).doubleValue() * rule.getValueFactor();
                } else if (beanValue instanceof Boolean) {
                    value = (Boolean)beanValue != false ? 1 : 0;
                } else {
                    LOGGER.fine("Ignoring unsupported bean: " + beanName + attrName + ": " + beanValue);
                    return;
                }
                if (rule.getName() == null) {
                    this.defaultExport(domain, beanProperties, attrKeys, rule.isAttrNameSnakeCase() ? attrNameSnakeCase : attrName, help, value, Collector.Type.valueOf((String)rule.getType().name()));
                    return;
                }
                assert (matcher != null);
                String name = JmxCollector.safeName(matcher.replaceAll(rule.getName()));
                if (name.isEmpty()) {
                    return;
                }
                if (JmxCollector.this.config.isLowercaseOutputName()) {
                    name = name.toLowerCase();
                }
                if (rule.getHelp() != null) {
                    help = matcher.replaceAll(rule.getHelp());
                }
                ArrayList<String> labelNames = new ArrayList<String>();
                ArrayList<String> labelValues = new ArrayList<String>();
                if (rule.getLabelNames() != null) {
                    for (int i = 0; i < rule.getLabelNames().size(); ++i) {
                        String unsafeLabelName = (String)rule.getLabelNames().get(i);
                        String labelValReplacement = (String)rule.getLabelValues().get(i);
                        String labelName = JmxCollector.safeName(matcher.replaceAll(unsafeLabelName));
                        String labelValue = matcher.replaceAll(labelValReplacement);
                        if (JmxCollector.this.config.isLowercaseOutputName()) {
                            labelName = labelName.toLowerCase();
                        }
                        if (labelName.isEmpty() || labelValue.isEmpty()) continue;
                        labelNames.add(labelName);
                        labelValues.add(labelValue);
                    }
                }
                LOGGER.fine("add metric sample: " + name + " " + labelNames + " " + labelValues + " " + value.doubleValue());
                this.addSample(new Collector.MetricFamilySamples.Sample(name, labelNames, labelValues, value.doubleValue()), Collector.Type.valueOf((String)rule.getType().name()), help);
                return;
            }
        }
    }
}

