/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.soul.metrics.prometheus.collector;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.management.ObjectName;

public class JmxMBeanPropertyCache {
    private static final Pattern PROPERTY_PATTERN = Pattern.compile("([^,=:*?]+)=(\"(?:[^\\\\\"]*(?:\\\\.)?)*\"|[^,=:\"]*)");
    private final Map<ObjectName, Map<String, String>> keyPropertiesPerBean = new ConcurrentHashMap<ObjectName, Map<String, String>>();

    public Map<String, String> getKeyPropertyList(ObjectName mbeanName) {
        Map<String, String> keyProperties = this.keyPropertiesPerBean.get(mbeanName);
        if (keyProperties == null) {
            keyProperties = new LinkedHashMap<String, String>();
            String properties = mbeanName.getKeyPropertyListString();
            Matcher match = PROPERTY_PATTERN.matcher(properties);
            while (match.lookingAt()) {
                keyProperties.put(match.group(1), match.group(2));
                properties = properties.substring(match.end());
                if (properties.startsWith(",")) {
                    properties = properties.substring(1);
                }
                match.reset(properties);
            }
            this.keyPropertiesPerBean.put(mbeanName, keyProperties);
        }
        return keyProperties;
    }

    public void onlyKeepMBeans(Set<ObjectName> latestBeans) {
        for (ObjectName prevName : this.keyPropertiesPerBean.keySet()) {
            if (latestBeans.contains(prevName)) continue;
            this.keyPropertiesPerBean.remove(prevName);
        }
    }
}

