/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.soul.metrics.prometheus.register;

import io.prometheus.client.Counter;
import io.prometheus.client.Gauge;
import io.prometheus.client.Histogram;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.dromara.soul.metrics.api.MetricsRegister;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PrometheusMetricsRegister
implements MetricsRegister {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PrometheusMetricsRegister.class);
    private static final Map<String, Counter> COUNTER_MAP = new ConcurrentHashMap<String, Counter>();
    private static final Map<String, Gauge> GAUGE_MAP = new ConcurrentHashMap<String, Gauge>();
    private static final Map<String, Histogram> HISTOGRAM_MAP = new ConcurrentHashMap<String, Histogram>();

    public static PrometheusMetricsRegister getInstance() {
        return PrometheusMetricsRegisterHolder.INSTANCE;
    }

    public void registerCounter(String name, String[] labelNames, String document) {
        if (!COUNTER_MAP.containsKey(name)) {
            Counter.Builder builder = (Counter.Builder)((Counter.Builder)Counter.build().name(name)).help(document);
            if (null != labelNames) {
                builder.labelNames(labelNames);
            }
            COUNTER_MAP.put(name, (Counter)builder.register());
        }
    }

    public void registerGauge(String name, String[] labelNames, String document) {
        if (!GAUGE_MAP.containsKey(name)) {
            Gauge.Builder builder = (Gauge.Builder)((Gauge.Builder)Gauge.build().name(name)).help(document);
            if (null != labelNames) {
                builder.labelNames(labelNames);
            }
            GAUGE_MAP.put(name, (Gauge)builder.register());
        }
    }

    public void registerHistogram(String name, String[] labelNames, String document) {
        if (!HISTOGRAM_MAP.containsKey(name)) {
            Histogram.Builder builder = (Histogram.Builder)((Histogram.Builder)Histogram.build().name(name)).help(document);
            if (null != labelNames) {
                builder.labelNames(labelNames);
            }
            HISTOGRAM_MAP.put(name, (Histogram)builder.register());
        }
    }

    public void counterIncrement(String name, String[] labelValues) {
        Counter counter = COUNTER_MAP.get(name);
        if (null != labelValues) {
            ((Counter.Child)counter.labels(labelValues)).inc();
        } else {
            counter.inc();
        }
    }

    public void counterIncrement(String name, String[] labelValues, long count) {
        Counter counter = COUNTER_MAP.get(name);
        if (null != labelValues) {
            ((Counter.Child)counter.labels(labelValues)).inc((double)count);
        } else {
            counter.inc((double)count);
        }
    }

    public void gaugeIncrement(String name, String[] labelValues) {
        Gauge gauge = GAUGE_MAP.get(name);
        if (null != labelValues) {
            ((Gauge.Child)gauge.labels(labelValues)).inc();
        } else {
            gauge.inc();
        }
    }

    public void gaugeDecrement(String name, String[] labelValues) {
        Gauge gauge = GAUGE_MAP.get(name);
        if (null != labelValues) {
            ((Gauge.Child)gauge.labels(labelValues)).dec();
        } else {
            gauge.dec();
        }
    }

    public void recordTime(String name, String[] labelValues, long duration) {
        Histogram histogram = HISTOGRAM_MAP.get(name);
        if (null != labelValues) {
            ((Histogram.Child)histogram.labels(labelValues)).observe((double)duration);
        } else {
            histogram.observe((double)duration);
        }
    }

    private static class PrometheusMetricsRegisterHolder {
        private static final PrometheusMetricsRegister INSTANCE = new PrometheusMetricsRegister();

        private PrometheusMetricsRegisterHolder() {
        }
    }
}

