/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.soul.metrics.prometheus.service;

import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.exporter.HTTPServer;
import io.prometheus.client.hotspot.DefaultExports;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.management.MalformedObjectNameException;
import lombok.Generated;
import org.dromara.soul.metrics.api.MetricsRegister;
import org.dromara.soul.metrics.config.MetricsConfig;
import org.dromara.soul.metrics.prometheus.collector.BuildInfoCollector;
import org.dromara.soul.metrics.prometheus.collector.JmxCollector;
import org.dromara.soul.metrics.prometheus.register.PrometheusMetricsRegister;
import org.dromara.soul.metrics.reporter.MetricsReporter;
import org.dromara.soul.metrics.spi.MetricsBootService;
import org.dromara.soul.spi.Join;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Join
public final class PrometheusBootService
implements MetricsBootService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PrometheusBootService.class);
    private HTTPServer server;
    private volatile AtomicBoolean registered = new AtomicBoolean(false);

    public void start(MetricsConfig metricsConfig) {
        this.startServer(metricsConfig);
        MetricsReporter.register((MetricsRegister)PrometheusMetricsRegister.getInstance());
    }

    public void stop() {
        if (this.server != null) {
            this.server.stop();
        }
    }

    private void startServer(MetricsConfig metricsConfig) {
        this.register(metricsConfig.getJmxConfig());
        int port = metricsConfig.getPort();
        String host = metricsConfig.getHost();
        InetSocketAddress inetSocketAddress = null == host || "".equalsIgnoreCase(host) ? new InetSocketAddress(port) : new InetSocketAddress(host, port);
        try {
            this.server = new HTTPServer(inetSocketAddress, CollectorRegistry.defaultRegistry, true);
            log.info(String.format("Prometheus metrics HTTP server `%s:%s` start success.", inetSocketAddress.getHostString(), inetSocketAddress.getPort()));
        }
        catch (IOException ex) {
            log.error("Prometheus metrics HTTP server start fail", (Throwable)ex);
        }
    }

    private void register(String jmxConfig) {
        if (!this.registered.compareAndSet(false, true)) {
            return;
        }
        new BuildInfoCollector().register();
        try {
            new JmxCollector(jmxConfig).register();
            DefaultExports.initialize();
        }
        catch (MalformedObjectNameException e) {
            log.error("init jxm collector error", (Throwable)e);
        }
    }

    @Generated
    public HTTPServer getServer() {
        return this.server;
    }

    @Generated
    public AtomicBoolean getRegistered() {
        return this.registered;
    }
}

